/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.channel;

import com.swak.rxtx.channel.Channel;
import com.swak.rxtx.channel.ChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPipeline
extends ChannelHandler {
    private static Logger logger = LoggerFactory.getLogger(Channel.class);
    private ChannelHandler head;
    private ChannelHandler tail;
    private Channel channel;

    public ChannelPipeline(Channel channel) {
        this.channel = channel;
        this.head = this;
        this.tail = this;
    }

    public Channel channel() {
        return this.channel;
    }

    public ChannelPipeline add(ChannelHandler handler) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u8bbe\u5907\uff1a[{}], \u6dfb\u52a0\u5904\u7406\u5668\uff1a[{}]", (Object)this.channel.comm(), (Object)handler.getClass().getSimpleName());
        }
        handler.prev = this.tail;
        this.tail.next = handler;
        this.tail = handler;
        return this;
    }

    public void fireConnectEvent(Channel channel) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.head.connect(channel));
        } else {
            this.head.connect(channel);
        }
    }

    public void fireReadEvent(Channel channel, Object data) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.head.read(channel, data));
        } else {
            this.head.read(channel, data);
        }
    }

    public void fireWriteEvent(Channel channel, Object data) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.tail.write(channel, data));
        } else {
            this.tail.write(channel, data);
        }
    }

    public void fireHeartbeatEvent(Channel channel) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.head.heartbeat(channel));
        } else {
            this.head.heartbeat(channel);
        }
    }

    public void fireCloseEvent(Channel channel) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.head.close(channel));
        } else {
            this.head.close(channel);
        }
    }

    public void fireCustomEvent(Channel channel, Object event) {
        if (!channel.inEventLoop()) {
            channel.execute(() -> this.head.custom(channel, event));
        } else {
            this.head.custom(channel, event);
        }
    }

    @Override
    public void write(Channel channel, Object data) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5904\u7406\u8bbe\u5907\uff1a[{}]\u5199\u6570\u636e\u4e8b\u4ef6, \u5904\u7406\u5668:[{}]", (Object)channel.comm(), (Object)this.getClass().getSimpleName());
        }
        if (data instanceof byte[]) {
            byte[] command = (byte[])data;
            channel.writeAndFlush(command);
        }
    }
}

