/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.channel;

import com.swak.reactivex.threads.Context;
import com.swak.reactivex.threads.SwakThreadFactory;
import com.swak.rxtx.channel.EventLoopGroup;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EventLoop
extends ThreadPoolExecutor
implements Context {
    private EventLoopGroup parent;
    private volatile Thread thread;

    public EventLoop() {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new SwakThreadFactory("Channels.EventLoop-", true, new AtomicInteger(0)));
    }

    @Override
    public void execute(Runnable task) {
        ObjectUtil.checkNotNull((Object)task, (String)"task");
        if (!this.inEventLoop()) {
            super.execute(() -> {
                this.thread = Thread.currentThread();
                this.executeTask(task);
            });
        } else {
            super.execute(task);
        }
    }

    public EventLoopGroup getParent() {
        return this.parent;
    }

    public EventLoop setParent(EventLoopGroup parent) {
        this.parent = parent;
        return this;
    }

    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }
}

