/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.codec;

import com.swak.codec.Hex;
import com.swak.rxtx.utils.CRC16Utils;
import com.swak.utils.StringUtils;

public interface Encodes {
    default public String encodeHex(byte ... input) {
        return new String(Hex.encodeHex((byte[])input, (boolean)false));
    }

    default public byte[] decodeHex(String input) {
        return Hex.decodeHex((char[])input.toCharArray());
    }

    default public String crc16(String data, boolean reverse) {
        if (!data.startsWith("SD")) {
            return this.crc16(this.decodeHex(data), reverse);
        }
        return data;
    }

    default public String crc16(byte[] bytes, boolean reverse) {
        int CRC = CRC16Utils.CRC16_MODBUS(bytes, 0, bytes.length);
        if (reverse) {
            int h_crc = (CRC & 0xFF) << 8;
            int s_crc = CRC >>> 8 & 0xFF;
            CRC = h_crc + s_crc;
        }
        return "SD" + StringUtils.leftPad((String)Integer.toHexString(CRC).toUpperCase(), (int)4, (String)"0");
    }
}

