/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.codec;

import com.swak.rxtx.channel.Channel;
import com.swak.rxtx.codec.ByteToMessageDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class FixedLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int frameLength;

    public FixedLengthFrameDecoder(int frameLength) {
        ObjectUtil.checkPositive((int)frameLength, (String)"frameLength");
        this.frameLength = frameLength;
    }

    @Override
    protected void decode(Channel channel, ByteBuf in, List<Object> out) throws Exception {
        Object decoded = this.decode(channel, in);
        if (decoded != null) {
            out.add(decoded);
        }
    }

    protected Object decode(Channel channel, ByteBuf in) throws Exception {
        if (in.readableBytes() < this.frameLength) {
            return null;
        }
        return in.readRetainedSlice(this.frameLength);
    }
}

