/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.utils;

public class CRC32Utils {
    public static long CRC32(byte[] source, int offset, int length) {
        long wCRCin = 0xFFFFFFFFL;
        long wCPoly = 3988292384L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            wCRCin ^= (long)source[i] & 0xFFL;
            for (int j = 0; j < 8; ++j) {
                if ((wCRCin & 1L) != 0L) {
                    wCRCin >>= 1;
                    wCRCin ^= wCPoly;
                    continue;
                }
                wCRCin >>= 1;
            }
        }
        return wCRCin ^= 0xFFFFFFFFL;
    }

    public static long CRC32_B(byte[] source, int offset, int length) {
        long wCRCin = 0xFFFFFFFFL;
        long wCPoly = 79764919L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean bit = (source[i] >> 7 - j & 1) == 1;
                boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                wCRCin <<= 1;
                if (!(c31 ^ bit)) continue;
                wCRCin ^= wCPoly;
            }
        }
        wCRCin &= 0xFFFFFFFFL;
        return wCRCin ^= 0xFFFFFFFFL;
    }

    public static long CRC32_C(byte[] source, int offset, int length) {
        long wCRCin = 0xFFFFFFFFL;
        long wCPoly = 2197175160L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            wCRCin ^= (long)source[i] & 0xFFL;
            for (int j = 0; j < 8; ++j) {
                if ((wCRCin & 1L) != 0L) {
                    wCRCin >>= 1;
                    wCRCin ^= wCPoly;
                    continue;
                }
                wCRCin >>= 1;
            }
        }
        return wCRCin ^= 0xFFFFFFFFL;
    }

    public static long CRC32_D(byte[] source, int offset, int length) {
        long wCRCin = 0xFFFFFFFFL;
        long wCPoly = 3558460437L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            wCRCin ^= (long)source[i] & 0xFFL;
            for (int j = 0; j < 8; ++j) {
                if ((wCRCin & 1L) != 0L) {
                    wCRCin >>= 1;
                    wCRCin ^= wCPoly;
                    continue;
                }
                wCRCin >>= 1;
            }
        }
        return wCRCin ^= 0xFFFFFFFFL;
    }

    public static long CRC32_MPEG_2(byte[] source, int offset, int length) {
        long wCRCin = 0xFFFFFFFFL;
        long wCPoly = 79764919L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean bit = (source[i] >> 7 - j & 1) == 1;
                boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                wCRCin <<= 1;
                if (!(c31 ^ bit)) continue;
                wCRCin ^= wCPoly;
            }
        }
        wCRCin &= 0xFFFFFFFFL;
        return wCRCin ^= 0L;
    }

    public static long CRC32_POSIX(byte[] source, int offset, int length) {
        long wCRCin = 0L;
        long wCPoly = 79764919L;
        int cnt = offset + length;
        for (int i = offset; i < cnt; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean bit = (source[i] >> 7 - j & 1) == 1;
                boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                wCRCin <<= 1;
                if (!(c31 ^ bit)) continue;
                wCRCin ^= wCPoly;
            }
        }
        wCRCin &= 0xFFFFFFFFL;
        return wCRCin ^= 0xFFFFFFFFL;
    }
}

