/*
 * Decompiled with CFR 0.152.
 */
package com.swak.rxtx.utils;

import gnu.io.CommPortIdentifier;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class SerialUtils {
    public static List<String> getCommNames() {
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> list = new ArrayList<String>();
        while (portIdentifiers.hasMoreElements()) {
            list.add(((CommPortIdentifier)portIdentifiers.nextElement()).getName());
        }
        return list.isEmpty() ? null : list;
    }

    public static SerialPort connect(String portName, int baudRate, int dataBits, int stopBits, int parity) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.err.println("Error: Port is currently in use");
        } else {
            RXTXPort commPort = portIdentifier.open(SerialUtils.class.getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = commPort;
                serialPort.setSerialPortParams(baudRate, dataBits, stopBits, parity);
                return commPort;
            }
            System.err.println("Error: Only serial ports are handled by this example.");
        }
        return null;
    }

    public static SerialPort connect(String portName, int baudRate) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
        if (portIdentifier.isCurrentlyOwned()) {
            System.err.println("Error: Port is currently in use");
        } else {
            RXTXPort commPort = portIdentifier.open(SerialUtils.class.getName(), 2000);
            if (commPort instanceof SerialPort) {
                SerialPort serialPort = commPort;
                serialPort.setSerialPortParams(baudRate, 8, 1, 0);
                return commPort;
            }
            System.err.println("Error: Only serial ports are handled by this example.");
        }
        return null;
    }
}

