/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.factory;

import gnu.io.SerialPort;
import gnu.io.factory.RxTxPortCreator;
import gnu.io.factory.SerialPortCreator;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class SerialPortRegistry {
    private Collection<SerialPortCreator<? extends SerialPort>> portCreators = new TreeSet<SerialPortCreator<? extends SerialPort>>(new Comparator<SerialPortCreator<? extends SerialPort>>(){

        @Override
        public int compare(SerialPortCreator<? extends SerialPort> o1, SerialPortCreator<? extends SerialPort> o2) {
            if (o1.getProtocol().equals("local")) {
                return 1;
            }
            if (o2.getProtocol().equals("local")) {
                return -1;
            }
            return o1.getProtocol().compareTo(o2.getProtocol());
        }
    });

    public SerialPortRegistry() {
        this.registerDefaultSerialPortCreators();
    }

    protected void registerDefaultSerialPortCreators() {
        this.registerSerialPortCreator(new RxTxPortCreator());
    }

    public void registerSerialPortCreator(SerialPortCreator<? extends SerialPort> creator) {
        this.portCreators.add(creator);
    }

    public <T extends SerialPort> SerialPortCreator<T> getPortCreatorForPortName(String portName, Class<T> expectedClass) {
        for (SerialPortCreator<? extends SerialPort> creator : this.portCreators) {
            try {
                if (!creator.isApplicable(portName, expectedClass)) continue;
                return creator;
            }
            catch (Exception e) {
                System.err.println("Error for SerialPortCreator#isApplicable: " + creator.getClass() + "; " + creator.getProtocol() + " -> " + e.getMessage());
            }
        }
        return null;
    }
}

