/*
 * Decompiled with CFR 0.152.
 */
package com.swak.zookeeper.curator;

import com.swak.lock.Lock;
import com.swak.utils.Sets;
import com.swak.zookeeper.ChildListener;
import com.swak.zookeeper.DataListener;
import com.swak.zookeeper.EventType;
import com.swak.zookeeper.StateListener;
import com.swak.zookeeper.ZookeeperService;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.api.DeleteOption;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorZookeeperService
implements ZookeeperService,
ConnectionStateListener,
Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(ZookeeperService.class);
    protected static final Charset CHARSET = Charset.forName("UTF-8");
    private final Set<StateListener> stateListeners = new CopyOnWriteArraySet<StateListener>();
    private final ConcurrentMap<String, ConcurrentMap<ChildListener, CuratorWatcherImpl>> childListeners = new ConcurrentHashMap<String, ConcurrentMap<ChildListener, CuratorWatcherImpl>>();
    private final ConcurrentMap<String, ConcurrentMap<DataListener, CuratorWatcherImpl>> listeners = new ConcurrentHashMap<String, ConcurrentMap<DataListener, CuratorWatcherImpl>>();
    private Map<String, TreeCache> treeCacheMap = new ConcurrentHashMap<String, TreeCache>();
    private final long UNKNOWN_SESSION_ID = -1L;
    private long lastSessionId;
    private CuratorFramework client;
    private AsyncCuratorFramework asyncClient;

    public CuratorZookeeperService(CuratorFramework client) {
        this.client = client;
        this.asyncClient = AsyncCuratorFramework.wrap((CuratorFramework)client);
        this.client.getConnectionStateListenable().addListener((Object)this);
        this.client.start();
    }

    @Override
    public long id() {
        return this.lastSessionId;
    }

    @Override
    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    @Override
    public void removeStateListener(StateListener listener) {
        this.stateListeners.remove(listener);
    }

    public Set<StateListener> getSessionListeners() {
        return this.stateListeners;
    }

    protected void triggerStateChanged(int state) {
        for (StateListener sessionListener : this.getSessionListeners()) {
            sessionListener.stateChanged(state);
        }
    }

    @Override
    public List<String> addChildListener(String path, ChildListener listener) {
        ConcurrentMap listeners = this.childListeners.computeIfAbsent(path, k -> new ConcurrentHashMap());
        CuratorWatcherImpl targetListener = listeners.computeIfAbsent(listener, k -> this.createTargetChildListener(path, (ChildListener)k));
        return this.addTargetChildListener(path, targetListener);
    }

    @Override
    public void addDataListener(String path, DataListener listener) {
        this.addDataListener(path, listener, null);
    }

    @Override
    public void addDataListener(String path, DataListener listener, Executor executor) {
        ConcurrentMap dataListenerMap = this.listeners.computeIfAbsent(path, k -> new ConcurrentHashMap());
        CuratorWatcherImpl targetListener = dataListenerMap.computeIfAbsent(listener, k -> this.createTargetDataListener(path, (DataListener)k));
        this.addTargetDataListener(path, targetListener, executor);
    }

    @Override
    public void removeDataListener(String path, DataListener listener) {
        CuratorWatcherImpl targetListener;
        ConcurrentMap dataListenerMap = (ConcurrentMap)this.listeners.get(path);
        if (dataListenerMap != null && (targetListener = (CuratorWatcherImpl)dataListenerMap.remove(listener)) != null) {
            this.removeTargetDataListener(path, targetListener);
        }
    }

    @Override
    public void removeChildListener(String path, ChildListener listener) {
        CuratorWatcherImpl targetListener;
        ConcurrentMap listeners = (ConcurrentMap)this.childListeners.get(path);
        if (listeners != null && (targetListener = (CuratorWatcherImpl)listeners.remove(listener)) != null) {
            this.removeTargetChildListener(path, targetListener);
        }
    }

    protected CuratorWatcherImpl createTargetChildListener(String path, ChildListener listener) {
        return new CuratorWatcherImpl(this.client, listener, path);
    }

    protected List<String> addTargetChildListener(String path, CuratorWatcherImpl listener) {
        try {
            return (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)listener)).forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected CuratorWatcherImpl createTargetDataListener(String path, DataListener listener) {
        return new CuratorWatcherImpl(this.client, listener);
    }

    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        this.addTargetDataListener(path, treeCacheListener, null);
    }

    protected void addTargetDataListener(String path, CuratorWatcherImpl treeCacheListener, Executor executor) {
        try {
            TreeCache treeCache = TreeCache.newBuilder((CuratorFramework)this.client, (String)path).setCacheData(false).build();
            this.treeCacheMap.putIfAbsent(path, treeCache);
            if (executor == null) {
                treeCache.getListenable().addListener((Object)treeCacheListener);
            } else {
                treeCache.getListenable().addListener((Object)treeCacheListener, executor);
            }
            treeCache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Add treeCache listener for path:" + path, e);
        }
    }

    protected void removeTargetDataListener(String path, CuratorWatcherImpl treeCacheListener) {
        TreeCache treeCache = this.treeCacheMap.get(path);
        if (treeCache != null) {
            treeCache.getListenable().removeListener((Object)treeCacheListener);
        }
        treeCacheListener.dataListener = null;
    }

    public void removeTargetChildListener(String path, CuratorWatcherImpl listener) {
        listener.unwatch();
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void stateChanged(CuratorFramework client, ConnectionState state) {
        long sessionId = -1L;
        try {
            sessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
        }
        catch (Exception e) {
            logger.warn("Curator client state changed, but failed to get the related zk session instance.");
        }
        if (state == ConnectionState.LOST) {
            logger.warn("Curator zookeeper session " + Long.toHexString(this.lastSessionId) + " expired.");
            this.triggerStateChanged(0);
        } else if (state == ConnectionState.SUSPENDED) {
            logger.warn("Curator zookeeper connection of session " + Long.toHexString(sessionId));
            this.triggerStateChanged(3);
        } else if (state == ConnectionState.CONNECTED) {
            this.lastSessionId = sessionId;
            logger.info("Curator zookeeper client instance initiated successfully, session id is " + Long.toHexString(sessionId));
            this.triggerStateChanged(1);
        } else if (state == ConnectionState.RECONNECTED) {
            if (this.lastSessionId == sessionId && sessionId != -1L) {
                logger.warn("Curator zookeeper connection recovered from connection lose, reuse the old session " + Long.toHexString(sessionId));
                this.triggerStateChanged(2);
            } else {
                logger.warn("New session created after old session lost, old session " + Long.toHexString(this.lastSessionId) + ", new session " + Long.toHexString(sessionId));
                this.lastSessionId = sessionId;
                this.triggerStateChanged(4);
            }
        }
    }

    @Override
    public String get(String path) {
        if (!this.checkExists(path)) {
            return null;
        }
        try {
            byte[] dataBytes = (byte[])this.client.getData().forPath(path);
            return dataBytes == null || dataBytes.length == 0 ? null : new String(dataBytes, CHARSET);
        }
        catch (KeeperException.NoNodeException dataBytes) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public void create(String path, CreateMode mode) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void create(String path, String content, CreateMode mode) {
        byte[] dataBytes = content.getBytes(CHARSET);
        if (this.checkExists(path)) {
            this.update(path, content);
        }
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, dataBytes);
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.client.setData().forPath(path, dataBytes);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e.getMessage(), e1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void update(String path, String content) {
        byte[] dataBytes = content.getBytes(CHARSET);
        try {
            this.client.setData().forPath(path, dataBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public List<String> getChildren(String path) {
        try {
            return (List)this.client.getChildren().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean checkExists(String path) {
        try {
            if (this.client.checkExists().forPath(path) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void delete(String path) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public CompletableFuture<Boolean> asyncCheckExists(String path) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        ((AsyncStage)this.asyncClient.checkExists().forPath(path)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(r != null);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<String> asyncGet(String path) {
        return this.asyncCheckExists(path).thenCompose(res -> {
            if (res.booleanValue()) {
                return this._asyncGet(path);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private CompletableFuture<String> _asyncGet(String path) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        ((AsyncStage)this.asyncClient.getData().forPath(path)).whenComplete((bytes, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(bytes == null || ((byte[])bytes).length == 0 ? null : new String((byte[])bytes, CHARSET));
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> asyncCreate(String path, CreateMode mode) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((AsyncStage)this.asyncClient.create().withOptions((Set)Sets.newHashSet((Object[])new CreateOption[]{CreateOption.createParentsIfNeeded}), mode).forPath(path)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> asyncCreate(String path, String content, CreateMode mode) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((CompletableFuture)this.asyncCheckExists(path).thenCompose(res -> {
            if (res.booleanValue()) {
                return this.asyncUpdate(path, content);
            }
            return this._asyncCreate(path, content, mode);
        })).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    public CompletableFuture<Void> _asyncCreate(String path, String content, CreateMode mode) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        byte[] dataBytes = content.getBytes(CHARSET);
        ((AsyncStage)this.asyncClient.create().withOptions((Set)Sets.newHashSet((Object[])new CreateOption[]{CreateOption.createParentsIfNeeded}), CreateMode.EPHEMERAL).forPath(path, dataBytes)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> asyncUpdate(String path, String content) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        byte[] dataBytes = content.getBytes(CHARSET);
        ((AsyncStage)this.asyncClient.setData().forPath(path, dataBytes)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<List<String>> asyncGetChildren(String path) {
        CompletableFuture<List<String>> result = new CompletableFuture<List<String>>();
        ((AsyncStage)this.asyncClient.getChildren().forPath(path)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete((List<String>)r);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> asyncDelete(String path) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        ((AsyncStage)this.asyncClient.delete().withOptions((Set)Sets.newHashSet((Object[])new DeleteOption[]{DeleteOption.deletingChildrenIfNeeded})).forPath(path)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    @Override
    public Lock newLock(final String path) {
        final InterProcessMutex interLock = new InterProcessMutex(this.client, path);
        return new Lock(){

            public String name() {
                return path;
            }

            public void lock() {
                try {
                    interLock.acquire();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void unlock() {
                try {
                    interLock.release();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static class CuratorWatcherImpl
    implements CuratorWatcher,
    TreeCacheListener {
        private CuratorFramework client;
        private volatile ChildListener childListener;
        private volatile DataListener dataListener;
        private String path;

        public CuratorWatcherImpl(CuratorFramework client, ChildListener listener, String path) {
            this.client = client;
            this.childListener = listener;
            this.path = path;
        }

        public CuratorWatcherImpl(CuratorFramework client, DataListener dataListener) {
            this.dataListener = dataListener;
        }

        protected CuratorWatcherImpl() {
        }

        public void unwatch() {
            this.childListener = null;
        }

        public void process(WatchedEvent event) throws Exception {
            if (event.getType() == Watcher.Event.EventType.None) {
                return;
            }
            if (this.childListener != null) {
                this.childListener.childChanged(this.path, (List)((BackgroundPathable)this.client.getChildren().usingWatcher((CuratorWatcher)this)).forPath(this.path));
            }
        }

        public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
            if (this.dataListener != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("listen the zookeeper changed. The changed data:" + event.getData());
                }
                TreeCacheEvent.Type type = event.getType();
                EventType eventType = null;
                String content = null;
                String path = null;
                switch (type) {
                    case NODE_ADDED: {
                        eventType = EventType.NodeCreated;
                        path = event.getData().getPath();
                        content = event.getData().getData() == null ? "" : new String(event.getData().getData(), CHARSET);
                        break;
                    }
                    case NODE_UPDATED: {
                        eventType = EventType.NodeDataChanged;
                        path = event.getData().getPath();
                        content = event.getData().getData() == null ? "" : new String(event.getData().getData(), CHARSET);
                        break;
                    }
                    case NODE_REMOVED: {
                        path = event.getData().getPath();
                        eventType = EventType.NodeDeleted;
                        break;
                    }
                    case INITIALIZED: {
                        eventType = EventType.INITIALIZED;
                        break;
                    }
                    case CONNECTION_LOST: {
                        eventType = EventType.CONNECTION_LOST;
                        break;
                    }
                    case CONNECTION_RECONNECTED: {
                        eventType = EventType.CONNECTION_RECONNECTED;
                        break;
                    }
                    case CONNECTION_SUSPENDED: {
                        eventType = EventType.CONNECTION_SUSPENDED;
                    }
                }
                this.dataListener.dataChanged(path, content, eventType);
            }
        }
    }
}

