package com.github.bootfastconfig.result;

import com.github.bootfastconfig.springtool.MessageUtil;

/**
 * @author mister
 */
public class L18nResultCode implements ResultCode {

    private ResultCode resultCode;

    private Object[] args;

    public L18nResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;

    }

    public L18nResultCode(ResultCode resultCode, Object... args) {
        this.resultCode = resultCode;
        this.args = args;
    }

    @Override
    public String getMessage() {

        return MessageUtil.codLi18n(resultCode.getCode(), args, resultCode.getMessage());
    }

    @Override
    public String getCode() {
        return resultCode.getCode();
    }
}
