package com.github.bootfastconfig.springtool;

import com.github.bootfastconfig.result.ResultCode;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;

import java.util.Locale;


/**
 * @author mister
 */
public class MessageUtil {
    private static volatile MessageSource messageSource;

    private static Object lock = new Object();

    private MessageUtil() {
    }

    private static void initMessageSource() {
        if (messageSource == null) {
            synchronized (lock) {
                if (messageSource == null) {
                    messageSource = SpringBeanUtil.getBean(MessageSource.class);
                }
            }
        }

    }


    public static String codLi18n(String code, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        initMessageSource();
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public static String codLi18n(String code) {
        return codLi18n(code, null, null, LocaleContextHolder.getLocale());
    }


    public static String codLi18n(ResultCode resultCode) {
        return codLi18n(resultCode.getCode(), null, resultCode.getMessage(), LocaleContextHolder.getLocale());
    }

    public static String codLi18n(ResultCode resultCode, Object[] args) {
        return codLi18n(resultCode.getCode(), args, resultCode.getMessage(), LocaleContextHolder.getLocale());
    }

    public static String codLi18n(ResultCode resultCode, Object[] args, Locale locale) {
        return codLi18n(resultCode.getCode(), args, resultCode.getMessage(), locale);
    }

    public static String codLi18n(String code, String defaultMessage) {
        return codLi18n(code, null, defaultMessage, LocaleContextHolder.getLocale());
    }

    public static String codLi18n(String code, Object[] args, String defaultMessage) {
        return codLi18n(code, args, defaultMessage, LocaleContextHolder.getLocale());
    }

}
