package com.github.bootfastconfig.springtool;

import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;

public abstract class ObjectUtil extends ObjectUtils {

    public static boolean isNotEmpty(@Nullable Object obj) {
        return !isEmpty(obj);
    }

    public static boolean hasEmpty(Object... os) {
        Object[] var1 = os;
        int var2 = os.length;

        for (int var3 = 0; var3 < var2; ++var3) {
            Object o = var1[var3];
            if (isEmpty(o)) {
                return true;
            }
        }

        return false;
    }

    public static boolean isNumber(Object o) {
        if (isEmpty(o)) {
            return false;
        }
        if (o instanceof Number) {
            return true;
        } else {
            try {
                new BigDecimal(o.toString());
            } catch (NumberFormatException e) {
                return false;
            }

        }
        return true;
    }


}