/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.bootfastconfig.springtool.ObjectUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBinder {
    private static Logger logger = LoggerFactory.getLogger(JsonBinder.class);
    private ObjectMapper mapper = new ObjectMapper();

    public JsonBinder(JsonInclude.Include inclusion) {
        this.mapper.setSerializationInclusion(inclusion);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    }

    public static JsonBinder buildNormalBinder() {
        return new JsonBinder(JsonInclude.Include.ALWAYS);
    }

    public static JsonBinder buildNonNullBinder() {
        return new JsonBinder(JsonInclude.Include.NON_NULL);
    }

    public static JsonBinder buildNonDefaultBinder() {
        return new JsonBinder(JsonInclude.Include.NON_DEFAULT);
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) {
        if (ObjectUtil.isNotEmpty(jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            logger.warn("parse json string error:" + jsonString, (Throwable)e);
            return null;
        }
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public void setDateFormat(String pattern) {
        if (ObjectUtil.isNotEmpty(pattern)) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            this.mapper.setDateFormat((DateFormat)df);
        }
    }

    public <T> T update(String jsonString, T object) {
        try {
            return (T)this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        return null;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

