/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.springtool;

import com.github.bootfastconfig.result.ResultCode;
import com.github.bootfastconfig.springtool.SpringBeanUtil;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.Nullable;

public class MessageUtil {
    private static volatile MessageSource messageSource;
    private static Object lock;

    private MessageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMessageSource() {
        if (messageSource == null) {
            Object object = lock;
            synchronized (object) {
                if (messageSource == null) {
                    messageSource = SpringBeanUtil.getBean(MessageSource.class);
                }
            }
        }
    }

    public static String codLi18n(String code, @Nullable Object[] args, @Nullable String defaultMessage, Locale locale) {
        MessageUtil.initMessageSource();
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public static String codLi18n(String code) {
        return MessageUtil.codLi18n(code, null, null, LocaleContextHolder.getLocale());
    }

    public static String codLi18n(ResultCode resultCode) {
        return MessageUtil.codLi18n(resultCode.getCode(), null, resultCode.getMessage(), LocaleContextHolder.getLocale());
    }

    public static String codLi18n(ResultCode resultCode, Object[] args) {
        return MessageUtil.codLi18n(resultCode.getCode(), args, resultCode.getMessage(), LocaleContextHolder.getLocale());
    }

    public static String codLi18n(ResultCode resultCode, Object[] args, Locale locale) {
        return MessageUtil.codLi18n(resultCode.getCode(), args, resultCode.getMessage(), locale);
    }

    public static String codLi18n(String code, String defaultMessage) {
        return MessageUtil.codLi18n(code, null, defaultMessage, LocaleContextHolder.getLocale());
    }

    public static String codLi18n(String code, Object[] args, String defaultMessage) {
        return MessageUtil.codLi18n(code, args, defaultMessage, LocaleContextHolder.getLocale());
    }

    static {
        lock = new Object();
    }
}

