/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.springtool;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SpringBeanUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringBeanUtil.class);
    private static ApplicationContext applicationContext;
    private static BeanDefinitionRegistry beanDefinitionRegistry;

    public SpringBeanUtil() {
        SpringBeanUtil.injection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void SpringBeanUtilInit(ApplicationContext applicationContext) {
        if (applicationContext == null) return;
        Class<SpringBeanUtil> clazz = SpringBeanUtil.class;
        synchronized (SpringBeanUtil.class) {
            SpringBeanUtil.applicationContext = applicationContext;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean injection(Object c) {
        return SpringBeanUtil.injection(c, new Class[]{Autowired.class, Resource.class});
    }

    public static boolean injection(Object c, Class<? extends Annotation>[] annotations) {
        if (SpringBeanUtil.getApplicationContext() == null || c == null || annotations == null) {
            return false;
        }
        Reflections reflections = new Reflections(new Object[]{c.getClass(), new FieldAnnotationsScanner()});
        HashSet fields = new HashSet();
        Stream.of(annotations).map(o -> reflections.getFieldsAnnotatedWith(o)).filter(Objects::nonNull).forEach(o -> fields.addAll(o));
        for (Field field : fields) {
            Object bean = SpringBeanUtil.getBean(field);
            field.setAccessible(true);
            try {
                field.set(c, bean);
            }
            catch (IllegalAccessException e) {
                log.error("SpringBeanUtil\u6784\u9020\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        }
        return true;
    }

    private static Object getBean(Field field) {
        String name = field.getName();
        Object bean = null;
        try {
            bean = SpringBeanUtil.getApplicationContext().getBean(name);
        }
        catch (RuntimeException e) {
            log.error("\u67e5\u627ebean \u5931\u8d25 \u672a\u627e\u5230 \u540d\u79f0\u4e3a" + name + "\u7684\u5b9e\u4f53", (Throwable)e);
        }
        if (bean != null) {
            return bean;
        }
        return SpringBeanUtil.getApplicationContext().getBean(field.getType());
    }

    public static <T> T getBean(String beanName) {
        try {
            return (T)SpringBeanUtil.getApplicationContext().getBean(beanName);
        }
        catch (RuntimeException e) {
            log.error("\u67e5\u627ebean \u5931\u8d25 \u672a\u627e\u5230 \u540d\u79f0\u4e3a [{}] \u7684\u5b9e\u4f53", (Object)beanName, (Object)e);
            return null;
        }
    }

    public static <T> T getBean(Class<T> c) {
        return (T)SpringBeanUtil.getApplicationContext().getBean(c);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        return (T)SpringBeanUtil.getApplicationContext().getBean(name, requiredType);
    }

    public static <T> T classInitialization(Class<T> c, String name, Object ... constructorValues) {
        if (applicationContext.containsBean(name)) {
            return SpringBeanUtil.getBean(name, c);
        }
        BeanDefinition beanDefinition = SpringBeanUtil.getBeanDefinition(c, constructorValues);
        return SpringBeanUtil.classInitialization(c, name, beanDefinition);
    }

    public static <T> T classInitialization(Class<T> c, String name, BeanDefinition beanDefinition) {
        if (applicationContext.containsBean(name)) {
            return SpringBeanUtil.getBean(name, c);
        }
        BeanDefinitionRegistry beanFactory = SpringBeanUtil.getBeanDefinitionRegistry(applicationContext);
        beanFactory.registerBeanDefinition(name, beanDefinition);
        return SpringBeanUtil.getBean(name, c);
    }

    public static <T> BeanDefinition getBeanDefinition(Class<T> c, Object ... constructorValues) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(c);
        if (constructorValues != null) {
            for (Object constructorValue : constructorValues) {
                beanDefinitionBuilder.addConstructorArgValue(constructorValue);
            }
        }
        beanDefinitionBuilder.setScope("prototype");
        beanDefinitionBuilder.setAutowireMode(0);
        return beanDefinitionBuilder.getRawBeanDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BeanDefinitionRegistry getBeanDefinitionRegistry(ApplicationContext applicationContext) {
        if (beanDefinitionRegistry != null) return beanDefinitionRegistry;
        Class<SpringBeanUtil> clazz = SpringBeanUtil.class;
        synchronized (SpringBeanUtil.class) {
            if (beanDefinitionRegistry == null && applicationContext instanceof AnnotationConfigServletWebServerApplicationContext) {
                beanDefinitionRegistry = (BeanDefinitionRegistry)((AnnotationConfigServletWebServerApplicationContext)applicationContext).getBeanFactory();
            }
            if (beanDefinitionRegistry != null) return beanDefinitionRegistry;
            ConfigurableApplicationContext bean = SpringBeanUtil.getBean(ConfigurableApplicationContext.class);
            beanDefinitionRegistry = (BeanDefinitionRegistry)bean.getBeanFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return beanDefinitionRegistry;
        }
    }

    public static boolean removeBeanDefinition(String name) {
        BeanDefinitionRegistry beanFactory = SpringBeanUtil.getBeanDefinitionRegistry(applicationContext);
        try {
            beanFactory.removeBeanDefinition(name);
        }
        catch (Exception e) {
            log.error("\u5220\u9664bean\u5b9a\u4e49\u5931\u8d25 bean \u540d\u79f0 [{}]", (Object)name, (Object)e);
            return false;
        }
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringBeanUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

