/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.springtool;

import com.github.bootfastconfig.springtool.ObjectUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class StringUtil
extends StringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    public static final String COMMA = ",";
    public static final String NUll = "null";
    public static final String EMPTY = "";
    private static final String S_INT = "0123456789";
    private static final String S_STR = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String S_ALL = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    public static boolean isBlank(CharSequence cs) {
        return !StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return StringUtil.hasText((CharSequence)cs);
    }

    public static boolean isAnyBlank(CharSequence ... css) {
        return ObjectUtil.isEmpty((Object[])css) ? true : Stream.of(css).anyMatch(StringUtil::isBlank);
    }

    public static boolean isNoneBlank(CharSequence ... css) {
        return ObjectUtil.isEmpty((Object[])css) ? false : Stream.of(css).allMatch(StringUtil::isNotBlank);
    }

    public static boolean isAllBlank(CharSequence ... css) {
        return Stream.of(css).allMatch(StringUtil::isBlank);
    }

    public static boolean isNumeric(CharSequence cs) {
        char chr;
        if (StringUtil.isBlank(cs)) {
            return false;
        }
        int i = cs.length();
        do {
            if (--i >= 0) continue;
            return true;
        } while ((chr = cs.charAt(i)) >= '0' && chr <= '9');
        return false;
    }

    public static String format(@Nullable String message, @Nullable Map<String, Object> params) {
        if (message == null) {
            return EMPTY;
        }
        if (params != null && !params.isEmpty()) {
            int end;
            int start;
            StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
            int cursor = 0;
            while ((start = message.indexOf("${", cursor)) != -1 && (end = message.indexOf("}", start)) != -1) {
                sb.append(message, cursor, start);
                String key = message.substring(start + 2, end);
                Object value = params.get(StringUtil.trimWhitespace((String)key));
                sb.append(value == null ? EMPTY : value);
                cursor = end + 1;
            }
            sb.append(message.substring(cursor));
            return sb.toString();
        }
        return message;
    }

    public static String format(@Nullable String message, Object ... arguments) {
        if (message == null) {
            return EMPTY;
        }
        if (arguments != null && arguments.length != 0) {
            int end;
            int start;
            StringBuilder sb = new StringBuilder((int)((double)message.length() * 1.5));
            int cursor = 0;
            int argsLength = arguments.length;
            for (int index = 0; (start = message.indexOf(123, cursor)) != -1 && (end = message.indexOf(125, start)) != -1 && index < argsLength; ++index) {
                sb.append(message, cursor, start);
                sb.append(arguments[index]);
                cursor = end + 1;
            }
            sb.append(message.substring(cursor));
            return sb.toString();
        }
        return message;
    }

    public static String join(Collection<?> coll) {
        return StringUtil.collectionToCommaDelimitedString(coll);
    }

    public static String join(Collection<?> coll, String delim) {
        return StringUtil.collectionToDelimitedString(coll, (String)delim);
    }

    public static String join(Object[] arr) {
        return StringUtil.arrayToCommaDelimitedString((Object[])arr);
    }

    public static String join(Object[] arr, String delim) {
        return StringUtil.arrayToDelimitedString((Object[])arr, (String)delim);
    }

    public static boolean simpleMatch(@Nullable String pattern, @Nullable String str) {
        return PatternMatchUtils.simpleMatch((String)pattern, (String)str);
    }

    public static boolean simpleMatch(@Nullable String[] patterns, String str) {
        return PatternMatchUtils.simpleMatch((String[])patterns, (String)str);
    }

    public static String randomUUID() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return new UUID(random.nextLong(), random.nextLong()).toString().replace("-", EMPTY);
    }

    public static String escapeHtml(String html) {
        return HtmlUtils.htmlEscape((String)html);
    }

    public static String cleanChars(String txt) {
        return txt.replaceAll("[ \u3000`\u00b7\u2022\ufffd\u0001\\f\\t\\v\\s]", EMPTY);
    }

    public static String indexedFormat(CharSequence pattern, Object ... arguments) {
        return MessageFormat.format(pattern.toString(), arguments);
    }

    public static String format(CharSequence template, Map<?, ?> map) {
        if (null == template) {
            return null;
        }
        if (null != map && !map.isEmpty()) {
            String template2 = template.toString();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                template2 = template2.replace("{" + entry.getKey() + "}", StringUtil.toStr(entry.getValue()));
            }
            return template2;
        }
        return template.toString();
    }

    public static String toStr(Object str) {
        return StringUtil.toStr(str, EMPTY);
    }

    public static String toStr(Object str, String defaultValue) {
        return null != str && !str.equals(NUll) ? String.valueOf(str) : defaultValue;
    }

    public static String[] splitTrim(@Nullable String str, @Nullable String delimiter) {
        return StringUtil.delimitedListToStringArray((String)str, (String)delimiter, (String)" \t\n\n\f");
    }

    public static boolean contains(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar) > -1;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStr(str, testStrs);
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (!StringUtil.isEmpty((Object)str) && !ObjectUtil.isEmpty((Object[])testStrs)) {
            CharSequence[] var2 = testStrs;
            int var3 = testStrs.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                CharSequence checkStr = var2[var4];
                if (!str.toString().contains(checkStr)) continue;
                return checkStr.toString();
            }
            return null;
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toString().toLowerCase().contains(testStr.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStrIgnoreCase(str, testStrs);
    }

    public static String getContainsStrIgnoreCase(CharSequence str, CharSequence ... testStrs) {
        if (!StringUtil.isEmpty((Object)str) && !ObjectUtil.isEmpty((Object[])testStrs)) {
            CharSequence[] var2 = testStrs;
            int var3 = testStrs.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                CharSequence testStr = var2[var4];
                if (!StringUtil.containsIgnoreCase(str, testStr)) continue;
                return testStr.toString();
            }
            return null;
        }
        return null;
    }

    public static String sub(CharSequence str, int fromIndex, int toIndex) {
        if (StringUtil.isEmpty((Object)str)) {
            return EMPTY;
        }
        int len = str.length();
        if (fromIndex < 0) {
            if ((fromIndex += len) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex += len) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        return fromIndex == toIndex ? EMPTY : str.toString().substring(fromIndex, toIndex);
    }

    public static String subBefore(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        if (!StringUtil.isEmpty((Object)string) && separator != null) {
            String str = string.toString();
            String sep = separator.toString();
            if (sep.isEmpty()) {
                return EMPTY;
            }
            int pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return null == string ? null : string.toString();
    }

    public static String subAfter(CharSequence string, CharSequence separator, boolean isLastSeparator) {
        if (StringUtil.isEmpty((Object)string)) {
            return null == string ? null : string.toString();
        }
        if (separator == null) {
            return EMPTY;
        }
        String str = string.toString();
        String sep = separator.toString();
        int pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        return pos == -1 ? EMPTY : str.substring(pos + separator.length());
    }

    public static String subBetween(CharSequence str, CharSequence before, CharSequence after) {
        if (str != null && before != null && after != null) {
            int end;
            String str2 = str.toString();
            String before2 = before.toString();
            String after2 = after.toString();
            int start = str2.indexOf(before2);
            if (start != -1 && (end = str2.indexOf(after2, start + before2.length())) != -1) {
                return str2.substring(start + before2.length(), end);
            }
            return null;
        }
        return null;
    }

    public static String subBetween(CharSequence str, CharSequence beforeAndAfter) {
        return StringUtil.subBetween(str, beforeAndAfter, beforeAndAfter);
    }

    public static String removePrefix(CharSequence str, CharSequence prefix) {
        if (!StringUtil.isEmpty((Object)str) && !StringUtil.isEmpty((Object)prefix)) {
            String str2 = str.toString();
            return str2.startsWith(prefix.toString()) ? StringUtil.subSuf(str2, prefix.length()) : str2;
        }
        return EMPTY;
    }

    public static String removePrefixIgnoreCase(CharSequence str, CharSequence prefix) {
        if (!StringUtil.isEmpty((Object)str) && !StringUtil.isEmpty((Object)prefix)) {
            String str2 = str.toString();
            return str2.toLowerCase().startsWith(prefix.toString().toLowerCase()) ? StringUtil.subSuf(str2, prefix.length()) : str2;
        }
        return EMPTY;
    }

    public static String removeSuffix(CharSequence str, CharSequence suffix) {
        if (!StringUtil.isEmpty((Object)str) && !StringUtil.isEmpty((Object)suffix)) {
            String str2 = str.toString();
            return str2.endsWith(suffix.toString()) ? StringUtil.subPre(str2, str2.length() - suffix.length()) : str2;
        }
        return EMPTY;
    }

    public static String removeSufAndLowerFirst(CharSequence str, CharSequence suffix) {
        return StringUtil.firstCharToLower(StringUtil.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(CharSequence str, CharSequence suffix) {
        if (!StringUtil.isEmpty((Object)str) && !StringUtil.isEmpty((Object)suffix)) {
            String str2 = str.toString();
            return str2.toLowerCase().endsWith(suffix.toString().toLowerCase()) ? StringUtil.subPre(str2, str2.length() - suffix.length()) : str2;
        }
        return EMPTY;
    }

    public static String firstCharToLower(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpper(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String subPre(CharSequence string, int toIndex) {
        return StringUtil.sub(string, 0, toIndex);
    }

    public static String subSuf(CharSequence string, int fromIndex) {
        return StringUtil.isEmpty((Object)string) ? null : StringUtil.sub(string, fromIndex, string.length());
    }

    public static int indexOf(CharSequence str, char searchChar) {
        return StringUtil.indexOf(str, searchChar, 0);
    }

    public static int indexOf(CharSequence str, char searchChar, int start) {
        return str instanceof String ? ((String)str).indexOf(searchChar, start) : StringUtil.indexOf(str, searchChar, start, -1);
    }

    public static int indexOf(CharSequence str, char searchChar, int start, int end) {
        int len = str.length();
        if (start < 0 || start > len) {
            start = 0;
        }
        if (end > len || end < 0) {
            end = len;
        }
        for (int i = start; i < end; ++i) {
            if (str.charAt(i) != searchChar) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.indexOfIgnoreCase(str, searchStr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.indexOf(str, searchStr, fromIndex, true);
    }

    public static int indexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str != null && searchStr != null) {
            int endLimit;
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (fromIndex > (endLimit = str.length() - searchStr.length() + 1)) {
                return -1;
            }
            if (searchStr.length() == 0) {
                return fromIndex;
            }
            if (!ignoreCase) {
                return str.toString().indexOf(searchStr.toString(), fromIndex);
            }
            for (int i = fromIndex; i < endLimit; ++i) {
                if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        return StringUtil.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int fromIndex) {
        return StringUtil.lastIndexOf(str, searchStr, fromIndex, true);
    }

    public static int lastIndexOf(CharSequence str, CharSequence searchStr, int fromIndex, boolean ignoreCase) {
        if (str != null && searchStr != null) {
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            fromIndex = Math.min(fromIndex, str.length());
            if (searchStr.length() == 0) {
                return fromIndex;
            }
            if (!ignoreCase) {
                return str.toString().lastIndexOf(searchStr.toString(), fromIndex);
            }
            for (int i = fromIndex; i > 0; --i) {
                if (!StringUtil.isSubEquals(str, i, searchStr, 0, searchStr.length(), true)) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static int ordinalIndexOf(String str, String searchStr, int ordinal) {
        if (str != null && searchStr != null && ordinal > 0) {
            if (searchStr.length() == 0) {
                return 0;
            }
            int found = 0;
            int index = -1;
            do {
                if ((index = str.indexOf(searchStr, index + 1)) >= 0) continue;
                return index;
            } while (++found < ordinal);
            return index;
        }
        return -1;
    }

    public static boolean isSubEquals(CharSequence str1, int start1, CharSequence str2, int start2, int length, boolean ignoreCase) {
        return null != str1 && null != str2 ? str1.toString().regionMatches(ignoreCase, start1, str2.toString(), start2, length) : false;
    }

    public static boolean equals(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence str1, CharSequence str2) {
        return StringUtil.equals(str1, str2, true);
    }

    public static boolean equals(CharSequence str1, CharSequence str2, boolean ignoreCase) {
        if (null == str1) {
            return str2 == null;
        }
        if (null == str2) {
            return false;
        }
        return ignoreCase ? str1.toString().equalsIgnoreCase(str2.toString()) : str1.equals(str2);
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(CharSequence ... strs) {
        StringBuilder sb = new StringBuilder();
        CharSequence[] var2 = strs;
        int var3 = strs.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            CharSequence str = var2[var4];
            sb.append(str);
        }
        return sb;
    }

    public static StringBuilder appendBuilder(StringBuilder sb, CharSequence ... strs) {
        CharSequence[] var2 = strs;
        int var3 = strs.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            CharSequence str = var2[var4];
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(CharSequence str) {
        return null == str ? null : new StringReader(str.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence content, CharSequence strForSearch) {
        if (!ObjectUtil.hasEmpty(content, strForSearch) && strForSearch.length() <= content.length()) {
            int count = 0;
            int idx = 0;
            String content2 = content.toString();
            String strForSearch2 = strForSearch.toString();
            while ((idx = content2.indexOf(strForSearch2, idx)) > -1) {
                ++count;
                idx += strForSearch.length();
            }
            return count;
        }
        return 0;
    }

    public static int count(CharSequence content, char charForSearch) {
        int count = 0;
        if (StringUtil.isEmpty((Object)content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String underlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        String[] var3 = a = para.split("_");
        int var4 = a.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String s = var3[var5];
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToUnderline(String para) {
        para = StringUtil.firstCharToLower(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    public static String lineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        String[] var3 = a = para.split("-");
        int var4 = a.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String s = var3[var5];
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToLine(String para) {
        para = StringUtil.firstCharToLower(para);
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "-");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }
}

