/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.springtool;

import com.github.bootfastconfig.abnormal.ServiceRuntimeException;
import com.github.bootfastconfig.result.DefaultResultCode;
import com.github.bootfastconfig.result.ResultCode;
import com.github.bootfastconfig.result.ResultCodeEnum;
import com.github.bootfastconfig.springtool.SpringBeanUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class ValidatorUtil
extends ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtil.class);
    private static LocalValidatorFactoryBean globalValidator;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMessageSource() {
        if (globalValidator == null) {
            Object object = lock;
            synchronized (object) {
                if (globalValidator == null) {
                    globalValidator = SpringBeanUtil.getBean(LocalValidatorFactoryBean.class);
                }
            }
        }
    }

    public static <T> Set<ConstraintViolation<T>> anotValidator(T object, Class<?> ... groups) {
        ValidatorUtil.initMessageSource();
        Validator validator = globalValidator.getValidator();
        return validator.validate(object, (Class[])groups);
    }

    public static void dismantlingBindingResult(BindingResult bindingResult) throws ServiceRuntimeException {
        ValidatorUtil.dismantlingBindingResult(bindingResult, (ResultCode)ResultCodeEnum.VALIDATOR);
    }

    public static void validatorIsNotNull(Object o, ResultCode resultCode) throws ServiceRuntimeException {
        ValidatorUtil.validator(o, ObjectUtils::isEmpty, resultCode);
    }

    public static <T> void validator(T o, Predicate<T> predicate, ResultCode resultCode) throws ServiceRuntimeException {
        if (predicate.test(o)) {
            throw new ServiceRuntimeException(resultCode);
        }
    }

    public static void dismantlingBindingResult(BindingResult bindingResult, ResultCode resultCode) throws ServiceRuntimeException {
        List errorList;
        if (bindingResult.hasErrors() && (errorList = bindingResult.getAllErrors()) != null && !errorList.isEmpty()) {
            String collect = errorList.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(",", "[", "]"));
            throw new ServiceRuntimeException((ResultCode)new DefaultResultCode(resultCode.getCode(), collect));
        }
    }

    public static void onException(Object object, Class<?> ... groups) throws ServiceRuntimeException {
        ServiceRuntimeException exception = (ServiceRuntimeException)ValidatorUtil.validatorException(object, o -> {
            Iterator iterator = o.iterator();
            if (iterator.hasNext()) {
                ConstraintViolation objectConstraintViolation = (ConstraintViolation)iterator.next();
                return new ServiceRuntimeException((ResultCode)new DefaultResultCode(ResultCodeEnum.VALIDATOR.getCode(), objectConstraintViolation.getMessage()));
            }
            return null;
        }, groups);
        if (exception != null) {
            throw exception;
        }
    }

    private static Object validatorException(Object object, Function<Set<ConstraintViolation<Object>>, Exception> function, Class<?> ... groups) {
        Set<ConstraintViolation<Object>> excs = ValidatorUtil.anotValidator(object, groups);
        if (excs != null || excs.size() != 0) {
            return function.apply(excs);
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

