/*
 * Decompiled with CFR 0.152.
 */
package com.github.bootfastconfig.springtool;

import com.github.bootfastconfig.springtool.ClassUtil;
import com.github.bootfastconfig.springtool.StringUtil;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.function.Predicate;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;

public class WebUtil
extends WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);
    private static final String[] IP_HEADER_NAMES = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
    private static final Predicate<String> IP_PREDICATE = ip -> StringUtil.isBlank(ip) || "unknown".equalsIgnoreCase((String)ip);

    public static boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtil.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    @Nullable
    public static String getCookieVal(String name) {
        HttpServletRequest request = WebUtil.getRequest();
        Assert.notNull((Object)request, (String)"request from RequestContextHolder is null");
        return WebUtil.getCookieVal(request, name);
    }

    @Nullable
    public static String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = WebUtil.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public static void removeCookie(HttpServletResponse response, String key) {
        WebUtil.setCookie(response, key, null, 0);
    }

    public static void setCookie(HttpServletResponse response, String name, @Nullable String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static String getIP() {
        return WebUtil.getIP(WebUtil.getRequest());
    }

    @Nullable
    public static String getIP(@Nullable HttpServletRequest request) {
        String ipHeader;
        if (request == null) {
            return "";
        }
        String ip = null;
        String[] var2 = IP_HEADER_NAMES;
        int var3 = var2.length;
        for (int var4 = 0; var4 < var3 && IP_PREDICATE.test(ip = request.getHeader(ipHeader = var2[var4])); ++var4) {
        }
        if (IP_PREDICATE.test(ip)) {
            ip = request.getRemoteAddr();
        }
        return StringUtil.isBlank(ip) ? null : StringUtil.splitTrim(ip, ",")[0];
    }

    public static String getRequestParamString(HttpServletRequest request) {
        try {
            return WebUtil.getRequestStr(request);
        }
        catch (Exception var2) {
            return "";
        }
    }

    public static String getRequestStr(HttpServletRequest request) throws IOException {
        String queryString = request.getQueryString();
        return StringUtil.isNotBlank(queryString) ? new String(queryString.getBytes(Charsets.ISO_8859_1), Charsets.UTF_8).replaceAll("&amp;", "&").replaceAll("%22", "\"") : WebUtil.getRequestStr(request, WebUtil.getRequestBytes(request));
    }

    public static byte[] getRequestBytes(HttpServletRequest request) throws IOException {
        int contentLength = request.getContentLength();
        if (contentLength < 0) {
            return null;
        }
        return StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public static String getRequestInputStreamStr(HttpServletRequest request) throws IOException {
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        Charset charset = Charset.forName(charEncoding);
        return StreamUtils.copyToString((InputStream)request.getInputStream(), (Charset)charset);
    }

    public static String getRequestStr(HttpServletRequest request, byte[] buffer) throws IOException {
        String str;
        String charEncoding = request.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = "UTF-8";
        }
        if (StringUtil.isBlank(str = new String(buffer, charEncoding).trim())) {
            StringBuilder sb = new StringBuilder();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String key = (String)parameterNames.nextElement();
                String value = request.getParameter(key);
                StringUtil.appendBuilder(sb, key, "=", value, "&");
            }
            str = StringUtil.removeSuffix(sb.toString(), "&");
        }
        return str.replaceAll("&amp;", "&");
    }
}

