/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.enums;

import com.hld.query.util.StringUtils;

public enum AttrType {
    STRING("java.lang.String"),
    INT("int"),
    INTEGER("java.lang.Integer"),
    BASE_LONG("long"),
    LONG("java.lang.Long"),
    BASE_DOUBLE("double"),
    DOUBLE("java.lang.Double"),
    BASE_FLOAT("float"),
    FLOAT("java.lang.Float"),
    CHAR("char"),
    CHARACTER("java.lang.Character"),
    LOCAL_DATE_TIME("java.time.LocalDateTime"),
    LOCAL_DATE("java.time.LocalDate"),
    DATE("java.util.Date");

    private String name;

    private AttrType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAttrType(String attrType) {
        if (StringUtils.isBlank(attrType)) {
            return false;
        }
        for (AttrType type : AttrType.values()) {
            if (!type.getName().equals(attrType)) continue;
            return true;
        }
        return false;
    }

    public boolean isStringType(String attrType) {
        if (StringUtils.isBlank(attrType)) {
            return false;
        }
        return STRING.getName().equals(attrType);
    }

    public boolean isDateType(String attrType) {
        if (StringUtils.isBlank(attrType)) {
            return false;
        }
        return LOCAL_DATE_TIME.getName().equals(attrType) || LOCAL_DATE.getName().equals(attrType) || DATE.getName().equals(attrType);
    }
}

