/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.util;

import com.hld.query.exception.CommonException;
import com.hld.query.util.ReflexUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    private static final Logger log = LoggerFactory.getLogger(MapUtils.class);
    public static final String KEY_CLOB = "oracle.sql.CLOB";

    public static Map<String, Object> keysToCamel(Map<String, Object> params) throws IOException, SQLException {
        if (params == null) {
            throw new CommonException(10001, "\u53c2\u6570");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            String key = ReflexUtil.underlineToHump(mapKey);
            if (mapValue != null) {
                if (mapValue.toString().contains(KEY_CLOB)) {
                    String s = MapUtils.clobtostring((Clob)mapValue);
                    map.put(key, s);
                    continue;
                }
                map.put(key, mapValue);
                continue;
            }
            map.put(key, "");
        }
        return map;
    }

    public static List<Map<String, Object>> keysToCamelByList(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(12);
        if (params != null && params.size() > 0) {
            for (Map<String, Object> m : params) {
                try {
                    if (m == null) continue;
                    list.add(MapUtils.keysToCamel(m));
                }
                catch (IOException | SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private static String clobtostring(Clob clob) throws SQLException, IOException {
        String ret = "";
        Reader read = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(read);
        String s = br.readLine();
        StringBuilder sb = new StringBuilder();
        while (s != null) {
            sb.append(s);
            s = br.readLine();
        }
        ret = sb.toString();
        br.close();
        read.close();
        return ret;
    }
}

