/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.util;

import com.hld.query.annotations.TableFiledInfo;
import com.hld.query.annotations.TableRelations;
import com.hld.query.enums.DatabaseType;
import com.hld.query.exception.CommonException;
import com.hld.query.mapper.CommonMapper;
import com.hld.query.params.FilterType;
import com.hld.query.params.IFilter;
import com.hld.query.params.IOrderBy;
import com.hld.query.params.QueryOptions;
import com.hld.query.params.TableInfo;
import com.hld.query.util.MapUtils;
import com.hld.query.util.PageData;
import com.hld.query.util.ReflexUtil;
import com.hld.query.util.Result;
import com.hld.query.util.StringUtils;
import com.hld.query.wrapper.CommonWrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryUtils.class);
    private static String[] forbidColumns = new String[]{"creator", "createTime", "updater", "updateTime", "tenantId"};

    public static String splitSql(CommonWrapper wrapper) {
        String sql = "";
        sql = QueryUtils.splitWhereSql(wrapper);
        return sql;
    }

    public static QueryOptions splitOptions(QueryOptions params, Class c) {
        if (params == null) {
            return null;
        }
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        List<String> columns = params.getColumns();
        columns = QueryUtils.splitColumns(columns, tableInfos);
        params.setColumns(columns);
        List<IFilter> filters = params.getFilters();
        filters = QueryUtils.splitFilterNameAlias(filters, tableInfos);
        params.setFilters(filters);
        List<IOrderBy> orderBys = params.getOrderBys();
        orderBys = QueryUtils.splitOrderBys(orderBys, tableInfos);
        params.setOrderBys(orderBys);
        return params;
    }

    public static QueryOptions splitOptions(QueryOptions params, List<TableInfo> tableInfos) {
        if (params == null) {
            return null;
        }
        List<String> columns = params.getColumns();
        columns = QueryUtils.splitColumns(columns, tableInfos);
        params.setColumns(columns);
        List<IFilter> filters = params.getFilters();
        filters = QueryUtils.splitFilterNameAlias(filters, tableInfos);
        params.setFilters(filters);
        List<IOrderBy> orderBys = params.getOrderBys();
        orderBys = QueryUtils.splitOrderBys(orderBys, tableInfos);
        params.setOrderBys(orderBys);
        return params;
    }

    private static List<IFilter> splitFilterNameAlias(List<IFilter> filters, Class c) {
        if (filters == null || filters.size() == 0) {
            return filters;
        }
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        int size = tableInfos.size();
        int length = filters.size();
        block0: for (int i = 0; i < length; ++i) {
            IFilter filter = filters.get(i);
            if (filter == null || filter.getFilterName() == null) continue;
            if (filter.getFilterType() == null) {
                filter.setFilterType(FilterType.DEFAULT);
            }
            if (filter.getFilterType() == FilterType.OR_NEW || filter.getFilterType() == FilterType.AND_NEW) {
                QueryUtils.splitFilterNameAlias(filter.getChildren(), c);
                continue;
            }
            String filterName = filter.getFilterName();
            if (!StringUtils.isNotBlank(filterName)) continue;
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (filterName.equals(columnName2)) {
                    filterName = tableInfo.getTableAlias().toLowerCase() + "." + (StringUtils.isEmpty(tableInfo.getTableFieldName()) ? columnName2 : tableInfo.getTableFieldName());
                    filter.setFilterName(filterName);
                    filters.set(i, filter);
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, "\u65e0\u6b64\u8fc7\u6ee4\u53c2\u6570\uff1a" + filterName);
            }
        }
        return filters;
    }

    private static List<IFilter> splitFilterNameAlias(List<IFilter> filters, List<TableInfo> tableInfos) {
        if (filters == null || filters.size() == 0) {
            return filters;
        }
        if (tableInfos == null || tableInfos.size() <= 0) {
            throw new CommonException(10003, "params tableInfos is not null or empty");
        }
        int size = tableInfos.size();
        int length = filters.size();
        block0: for (int i = 0; i < length; ++i) {
            String filterName;
            IFilter filter = filters.get(i);
            if (filter == null) continue;
            if (filter.getFilterType() == null) {
                filter.setFilterType(FilterType.DEFAULT);
            }
            if (filter.getFilterType() == FilterType.OR_NEW || filter.getFilterType() == FilterType.AND_NEW) {
                QueryUtils.splitFilterNameAlias(filter.getChildren(), tableInfos);
                continue;
            }
            if (filter.getFilterName() == null || !StringUtils.isNotBlank(filterName = filter.getFilterName())) continue;
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (filterName.equals(columnName2)) {
                    filterName = tableInfo.getTableAlias().toLowerCase() + "." + (StringUtils.isEmpty(tableInfo.getTableFieldName()) ? columnName2 : tableInfo.getTableFieldName());
                    filter.setFilterName(filterName);
                    filters.set(i, filter);
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, "\u65e0\u6b64\u8fc7\u6ee4\u53c2\u6570\uff1a" + filterName);
            }
        }
        return filters;
    }

    public static String splitWhereSql(String sql, Map<String, Object> map) {
        if (StringUtils.isEmpty(sql) || map == null) {
            return sql;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String mapKey = entry.getKey();
            String replaceStr = "#{ew.paramNameValuePairs." + mapKey + "}";
            Object mapValue = entry.getValue();
            sql = sql.replace(replaceStr, mapValue == null ? "" : "'" + mapValue.toString() + "'");
        }
        return sql;
    }

    public static String splitWhereSql(CommonWrapper wrapper) {
        boolean isOrder;
        if (wrapper == null) {
            throw new CommonException(10001);
        }
        String sql = wrapper.getSqlSegment();
        Map map = wrapper.getParamNameValuePairs();
        if (StringUtils.isEmpty(sql) || map == null) {
            if (StringUtils.isNotBlank(wrapper.getFirstSql())) {
                return wrapper.getFirstSql();
            }
            return " 1=1 ";
        }
        List<IOrderBy> orderBys = wrapper.getOrderBys();
        List<IFilter> filters = wrapper.getFilters();
        boolean isFilter = filters == null || filters.size() == 0;
        boolean bl = isOrder = orderBys != null && orderBys.size() > 0;
        if (isOrder && isFilter) {
            if (StringUtils.isNotBlank(wrapper.getFirstSql())) {
                return wrapper.getFirstSql() + sql;
            }
            return " 1=1 " + sql;
        }
        for (Map.Entry entry : map.entrySet()) {
            String mapKey = (String)entry.getKey();
            String replaceStr = "#{ew.paramNameValuePairs." + mapKey + "}";
            Object mapValue = entry.getValue();
            sql = sql.replace(replaceStr, mapValue == null ? "" : "'" + mapValue.toString() + "'");
        }
        if (StringUtils.isNotBlank(wrapper.getFirstSql())) {
            return wrapper.getFirstSql() + " AND " + sql;
        }
        return sql;
    }

    public static String splitPage(String sql, CommonWrapper wrapper) {
        Long start = QueryUtils.getStartCount(wrapper.getCurPage(), wrapper.getLimit());
        Long end = QueryUtils.getEndCount(wrapper.getCurPage(), wrapper.getLimit());
        if (start != null && end != null) {
            sql = sql + " limit " + start + " , " + end;
        }
        return sql;
    }

    private static List<IOrderBy> splitOrderBys(List<IOrderBy> orderBys, Class c) {
        if (orderBys == null || orderBys.size() == 0) {
            return orderBys;
        }
        int length = orderBys.size();
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        int size = tableInfos.size();
        block0: for (int i = 0; i < length; ++i) {
            IOrderBy orderBy = orderBys.get(i);
            String orderByName = orderBy.getOrderByName();
            if (StringUtils.isEmpty(orderByName)) {
                throw new CommonException(10003, "\u6392\u5e8f\u53c2\u6570\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (orderByName.equals(columnName2)) {
                    orderByName = tableInfo.getTableAlias().toUpperCase() + "." + (StringUtils.isEmpty(tableInfo.getTableFieldName()) ? ReflexUtil.humpToUnderline(columnName2) : ReflexUtil.humpToUnderline(tableInfo.getTableFieldName()));
                    orderBy.setOrderByName(orderByName);
                    orderBys.set(i, orderBy);
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, "\u65e0\u6b64\u6392\u5e8f\u53c2\u6570\uff1a" + orderByName);
            }
        }
        return orderBys;
    }

    private static List<IOrderBy> splitOrderBys(List<IOrderBy> orderBys, List<TableInfo> tableInfos) {
        if (orderBys == null || orderBys.size() == 0) {
            return orderBys;
        }
        if (tableInfos == null || tableInfos.size() == 0) {
            throw new CommonException(10003, "params error : tableInfos is not null or empty");
        }
        int length = orderBys.size();
        int size = tableInfos.size();
        block0: for (int i = 0; i < length; ++i) {
            IOrderBy orderBy = orderBys.get(i);
            String orderByName = orderBy.getOrderByName();
            if (StringUtils.isEmpty(orderByName)) {
                throw new CommonException(10003, "\u6392\u5e8f\u53c2\u6570\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (orderByName.equals(columnName2)) {
                    orderByName = tableInfo.getTableAlias().toUpperCase() + "." + (StringUtils.isEmpty(tableInfo.getTableFieldName()) ? ReflexUtil.humpToUnderline(columnName2) : ReflexUtil.humpToUnderline(tableInfo.getTableFieldName()));
                    orderBy.setOrderByName(orderByName);
                    orderBys.set(i, orderBy);
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, "\u65e0\u6b64\u6392\u5e8f\u53c2\u6570\uff1a" + orderByName);
            }
        }
        return orderBys;
    }

    private static List<String> splitColumns(List<String> columns, Class c) {
        if (columns == null || columns.size() == 0) {
            throw new CommonException(10003, "params error : columns is not null or empty");
        }
        int length = columns.size();
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        int size = tableInfos.size();
        block0: for (int i = 0; i < length; ++i) {
            String columnName = columns.get(i);
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (columnName.equals(columnName2)) {
                    if (StringUtils.isNotEmpty(tableInfo.getTableFieldName())) {
                        builder.append("(").append(tableInfo.getTableAlias().toUpperCase()).append(".").append(ReflexUtil.humpToUnderline(tableInfo.getTableFieldName())).append(")").append(columnName);
                    } else {
                        builder.append(tableInfo.getTableAlias().toUpperCase()).append(".").append(ReflexUtil.humpToUnderline(columnName2));
                    }
                    columns.set(i, builder.toString());
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, " \uff1a" + columnName);
            }
        }
        return columns;
    }

    private static List<String> addColumns(List<TableInfo> tableInfos) {
        List<String> collect = tableInfos.parallelStream().map(TableInfo::getColumnName).collect(Collectors.toList());
        collect.removeAll(Arrays.asList(forbidColumns));
        return collect;
    }

    private static List<String> splitColumns(List<String> columns, List<TableInfo> tableInfos) {
        if (tableInfos == null || tableInfos.size() == 0) {
            throw new CommonException(10003, "params error : tableInfos is not null or empty");
        }
        if (columns == null || columns.size() == 0) {
            columns = QueryUtils.addColumns(tableInfos);
        }
        int length = columns.size();
        int size = tableInfos.size();
        block0: for (int i = 0; i < length; ++i) {
            String columnName = columns.get(i);
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < size; ++j) {
                TableInfo tableInfo = tableInfos.get(j);
                String columnName2 = tableInfo.getColumnName();
                if (columnName.equals(columnName2)) {
                    String filedSql = tableInfo.getFiledSql();
                    if (StringUtils.isNotBlank(filedSql)) {
                        builder.append("(").append(filedSql).append(")").append(ReflexUtil.humpToUnderline(columnName));
                    } else if (StringUtils.isNotEmpty(tableInfo.getTableFieldName())) {
                        builder.append("(").append(tableInfo.getTableAlias().toUpperCase()).append(".").append(ReflexUtil.humpToUnderline(tableInfo.getTableFieldName())).append(")").append(ReflexUtil.humpToUnderline(columnName));
                    } else {
                        builder.append(tableInfo.getTableAlias().toUpperCase()).append(".").append(ReflexUtil.humpToUnderline(columnName2));
                    }
                    columns.set(i, builder.toString());
                    continue block0;
                }
                if (j != size - 1) continue;
                throw new CommonException(10003, " \uff1a" + columnName);
            }
        }
        return columns;
    }

    private static List<TableInfo> getTableInfo(Class c) {
        Annotation[] classAnnotations;
        Field[] fields;
        Field[] parentFields;
        if (c == null || Object.class.equals((Object)c)) {
            throw new CommonException(10001, "params is not null");
        }
        String tableRelations = "";
        String mTableName = null;
        String mTableAlias = null;
        Class parentClass = c.getSuperclass();
        ArrayList allFields = new ArrayList();
        if (null != parentClass && !Object.class.equals(parentClass) && null != (parentFields = parentClass.getDeclaredFields()) && parentFields.length != 0) {
            Collections.addAll(allFields, parentFields);
        }
        if (null != (fields = c.getDeclaredFields()) && fields.length != 0) {
            Collections.addAll(allFields, fields);
        }
        if ((classAnnotations = c.getDeclaredAnnotations()) != null && classAnnotations.length > 0) {
            for (int i = 0; i < classAnnotations.length; ++i) {
                Annotation annotation = classAnnotations[i];
                if (annotation instanceof TableRelations) {
                    tableRelations = ((TableRelations)annotation).mRelation();
                    if (StringUtils.isEmpty(tableRelations)) {
                        throw new CommonException(10003, "\u6ce8\u89e3\u53c2\u6570\uff1a{relation} \u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    mTableAlias = ((TableRelations)annotation).mTableAlias();
                    mTableName = ((TableRelations)annotation).mTableName();
                    break;
                }
                if (i != classAnnotations.length - 1) continue;
                throw new CommonException(10003, c.getName() + "\u9700\u6dfb\u52a0\u8868\u95f4\u5173\u7cfb\u6ce8\u89e3 TableRelations");
            }
        } else {
            throw new CommonException(10003, c.getName() + "\u9700\u6dfb\u52a0\u8868\u95f4\u5173\u7cfb\u6ce8\u89e3 TableRelations");
        }
        ArrayList<TableInfo> tableInfos = new ArrayList(12);
        for (Field field : allFields) {
            Annotation[] annotations;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            String typeName = fieldType.getName();
            String fieldName = field.getName();
            for (Annotation annotation : annotations = field.getDeclaredAnnotations()) {
                if (!(annotation instanceof TableFiledInfo)) continue;
                String tableName = ((TableFiledInfo)annotation).tableName();
                String tableAlia = ((TableFiledInfo)annotation).tableAlias();
                String tableFieldName = ((TableFiledInfo)annotation).filedName();
                String filedSql = ((TableFiledInfo)annotation).filedSql();
                String relation = ((TableFiledInfo)annotation).relation();
                TableInfo tableInfo = new TableInfo();
                if (StringUtils.isEmpty(tableAlia) && StringUtils.isEmpty(mTableAlias)) {
                    throw new CommonException(10003, "table alias \u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                tableInfo.setTableName(StringUtils.isEmpty(tableName) ? mTableName : tableName).setTableAlias(StringUtils.isEmpty(tableAlia) ? mTableAlias : tableAlia).setTableFieldName(tableFieldName).setColumnName(fieldName).setAttrType(typeName).setFiledSql(filedSql).setRelation(relation);
                tableInfos.add(tableInfo);
            }
        }
        tableInfos = tableInfos.stream().distinct().collect(Collectors.toList());
        return tableInfos;
    }

    public static String getRelation(Class c) {
        Annotation[] classAnnotations = c.getDeclaredAnnotations();
        if (classAnnotations.length > 0) {
            for (int i = 0; i < classAnnotations.length; ++i) {
                Annotation annotation = classAnnotations[i];
                if (annotation instanceof TableRelations) {
                    String tableRelations = ((TableRelations)annotation).mRelation();
                    if (StringUtils.isEmpty(tableRelations)) {
                        throw new CommonException(10003, c.getName() + "\u9700\u6dfb\u52a0\u8868\u95f4\u5173\u7cfb\u53c2\u6570");
                    }
                    return tableRelations;
                }
                if (i != classAnnotations.length - 1) continue;
                throw new CommonException(10003, c.getName() + "\u9700\u6dfb\u52a0\u8868\u95f4\u5173\u7cfb\u6ce8\u89e3 TableRelations");
            }
        } else {
            throw new CommonException(10003, c.getName() + "\u9700\u6dfb\u52a0\u8868\u95f4\u5173\u7cfb\u6ce8\u89e3 TableRelations");
        }
        return "";
    }

    public static String getRelation(String relation, List<String> columns, List<TableInfo> tableInfos) {
        if (columns == null || columns.size() == 0) {
            columns = QueryUtils.addColumns(tableInfos);
        }
        StringBuffer buffer = new StringBuffer(relation);
        HashSet<String> relations = new HashSet<String>(12);
        for (String column : columns) {
            List collect = tableInfos.parallelStream().filter(r -> r.getColumnName().equals(column)).collect(Collectors.toList());
            System.out.println("curRelation : " + collect.toString());
            if (collect.size() <= 0) continue;
            relations.add(((TableInfo)collect.get(0)).getRelation());
        }
        for (String s : relations) {
            buffer.append(" ").append(s);
        }
        return buffer.toString();
    }

    public static Long getStartCount(Long curPage, Long limit) {
        if (curPage != null && limit != null) {
            return curPage < 1L ? 0L : (curPage - 1L) * limit;
        }
        return null;
    }

    public static Long getEndCount(Long curPage, Long limit) {
        return QueryUtils.getEndCount(curPage, limit, DatabaseType.MYSQL);
    }

    public static Long getEndCount(Long curPage, Long limit, DatabaseType type) {
        Long end = 0L;
        switch (type) {
            case MYSQL: {
                end = limit;
                break;
            }
            case ORACLE: {
                if (curPage == null || limit == null) break;
                end = curPage * limit;
                break;
            }
        }
        return end;
    }

    private static String splitPageOracle(String sql, CommonWrapper wrapper) {
        Long start = QueryUtils.getStartCount(wrapper.getCurPage(), wrapper.getLimit());
        Long end = QueryUtils.getEndCount(wrapper.getCurPage(), wrapper.getLimit(), DatabaseType.ORACLE);
        if (start != null && end != null && start < end) {
            sql = "SELECT *  FROM (SELECT tt.*, ROWNUM AS rowno FROM (" + sql + " )tt WHERE ROWNUM <= " + end + " ) table_alias WHERE table_alias.rowno > " + start;
        }
        return sql;
    }

    public static String getCompletedSQL(String relation, String whereSql, DatabaseType type, CommonWrapper wrapper) {
        if (StringUtils.isEmpty(relation)) {
            throw new CommonException("SQL\u62fc\u63a5\u9519\u8bef\uff0c\u53c2\u6570 relation \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(whereSql)) {
            throw new CommonException("SQL\u62fc\u63a5\u9519\u8bef\uff0c\u53c2\u6570 whereSql \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (type == null) {
            throw new CommonException("SQL\u62fc\u63a5\u9519\u8bef\uff0c\u53c2\u6570 DatabaseType \u4e0d\u80fd\u4e3anull");
        }
        if (wrapper == null) {
            throw new CommonException("SQL\u62fc\u63a5\u9519\u8bef\uff0cCommonWrapper \u4e0d\u80fd\u4e3anull");
        }
        String columns = wrapper.getSqlSelect();
        String sqlParams = "SELECT " + columns + " FROM " + relation + " WHERE " + whereSql;
        switch (type) {
            case MYSQL: {
                sqlParams = QueryUtils.splitPage(sqlParams, wrapper);
                break;
            }
            case ORACLE: {
                sqlParams = QueryUtils.splitPageOracle(sqlParams, wrapper);
                break;
            }
        }
        return sqlParams.toUpperCase();
    }

    public static Result getResult(CommonMapper baseMapper, QueryOptions params, Class c) {
        return QueryUtils.getResult(baseMapper, params, c, DatabaseType.MYSQL);
    }

    public static Result getResult(CommonMapper baseMapper, QueryOptions params, Class c, DatabaseType type) {
        if (type == null) {
            type = DatabaseType.MYSQL;
        }
        log.info("SysUser common query News Params \uff1a[{}] , database type [{}]", (Object)params.toString(), (Object)type);
        List<String> columns = params.getColumns();
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        CommonWrapper wrapper = new CommonWrapper(QueryUtils.splitOptions(params, tableInfos));
        String relation = QueryUtils.getRelation(QueryUtils.getRelation(c), columns, tableInfos);
        String whereSql = QueryUtils.splitSql(wrapper);
        Long total = baseMapper.commonQueryCount(whereSql, relation);
        List<Map<String, Object>> map = baseMapper.commonQueryByParams(QueryUtils.getCompletedSQL(relation, whereSql, type, wrapper));
        return new Result().success(new PageData<Map<String, Object>>(MapUtils.keysToCamelByList(map), total, wrapper.getCurPage()));
    }

    public static PageData getPageResult(CommonMapper baseMapper, QueryOptions params, Class c, DatabaseType type) {
        if (type == null) {
            type = DatabaseType.MYSQL;
        }
        log.info("SysUser common query News Params \uff1a[{}] , database type [{}]", (Object)params.toString(), (Object)type);
        List<String> columns = params.getColumns();
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        CommonWrapper wrapper = new CommonWrapper(QueryUtils.splitOptions(params, tableInfos));
        String relation = QueryUtils.getRelation(QueryUtils.getRelation(c), columns, tableInfos);
        String whereSql = QueryUtils.splitSql(wrapper);
        Long total = baseMapper.commonQueryCount(whereSql, relation);
        List<Map<String, Object>> map = baseMapper.commonQueryByParams(QueryUtils.getCompletedSQL(relation, whereSql, type, wrapper));
        return new PageData<Map<String, Object>>(MapUtils.keysToCamelByList(map), total, wrapper.getCurPage());
    }

    public static List<Map<String, Object>> getListResult(CommonMapper baseMapper, QueryOptions params, Class c, DatabaseType type) {
        if (type == null) {
            type = DatabaseType.MYSQL;
        }
        log.info("SysUser common query News Params \uff1a[{}] , database type [{}]", (Object)params.toString(), (Object)type);
        List<String> columns = params.getColumns();
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        CommonWrapper wrapper = new CommonWrapper(QueryUtils.splitOptions(params, tableInfos));
        String relation = QueryUtils.getRelation(QueryUtils.getRelation(c), columns, tableInfos);
        String whereSql = QueryUtils.splitSql(wrapper);
        List<Map<String, Object>> map = baseMapper.commonQueryByParams(QueryUtils.getCompletedSQL(relation, whereSql, type, wrapper));
        return MapUtils.keysToCamelByList(map);
    }

    public static String testSql(QueryOptions params, Class c, DatabaseType type) {
        if (type == null) {
            type = DatabaseType.MYSQL;
        }
        ArrayList<String> columns = new ArrayList<String>(12);
        columns.addAll(params.getColumns());
        List<TableInfo> tableInfos = QueryUtils.getTableInfo(c);
        CommonWrapper wrapper = new CommonWrapper(QueryUtils.splitOptions(params, tableInfos));
        String relation = QueryUtils.getRelation(QueryUtils.getRelation(c), columns, tableInfos);
        String whereSql = QueryUtils.splitSql(wrapper);
        return QueryUtils.getCompletedSQL(relation, whereSql, type, wrapper);
    }
}

