/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflexUtil {
    static Logger logger = LoggerFactory.getLogger(ReflexUtil.class);

    public static Object invokeMethod(String propertiesName, Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (!propertiesName.contains(".")) {
                String methodName = "get" + ReflexUtil.getMethodName(propertiesName);
                Method method = object.getClass().getMethod(methodName, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            String methodName = "get" + ReflexUtil.getMethodName(propertiesName.substring(0, propertiesName.indexOf(".")));
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            return ReflexUtil.invokeMethod(propertiesName.substring(propertiesName.indexOf(".") + 1), method.invoke(object, new Object[0]));
        }
        catch (Exception e) {
            logger.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    private static String getMethodName(String fildeName) {
        byte[] items = fildeName.getBytes();
        items[0] = (byte)((char)items[0] - 97 + 65);
        return new String(items);
    }

    public static Object getGetMethod(Object ob, String name) throws Exception {
        Method[] m = ob.getClass().getMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!("get" + name).toLowerCase().equals(m[i].getName().toLowerCase())) continue;
            return m[i].invoke(ob, new Object[0]);
        }
        return null;
    }

    public static void setValue(Object obj, Class<?> clazz, String filedName, Class<?> typeClass, Object value) {
        filedName = ReflexUtil.removeLine(filedName);
        String methodName = "set" + filedName.substring(0, 1).toUpperCase() + filedName.substring(1);
        try {
            Method method = clazz.getDeclaredMethod(methodName, typeClass);
            method.invoke(obj, ReflexUtil.getClassTypeValue(typeClass, value));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Object getClassTypeValue(Class<?> typeClass, Object value) {
        if (typeClass == Integer.TYPE || typeClass == Integer.class || value instanceof Integer) {
            if (null == value) {
                return 0;
            }
            return value;
        }
        if (typeClass == Short.TYPE || typeClass == Short.class || value instanceof Short) {
            if (null == value) {
                return 0;
            }
            return value;
        }
        if (typeClass == Byte.TYPE || typeClass == Byte.class || value instanceof Byte) {
            if (null == value) {
                return 0;
            }
            return value;
        }
        if (typeClass == Double.TYPE || typeClass == Double.class || value instanceof Double) {
            if (null == value) {
                return 0;
            }
            return value;
        }
        if (typeClass == Long.TYPE || typeClass == Long.class || value instanceof Long) {
            if (null == value) {
                return 0;
            }
            return value;
        }
        if (typeClass == String.class) {
            if (null == value) {
                return "";
            }
            return value;
        }
        if (typeClass == Boolean.TYPE || typeClass == Boolean.class || value instanceof Boolean) {
            if (null == value) {
                return true;
            }
            return value;
        }
        if (typeClass == BigDecimal.class) {
            if (null == value) {
                return new BigDecimal(0);
            }
            return new BigDecimal(value + "");
        }
        return typeClass.cast(value);
    }

    public static String removeLine(String str) {
        if (null != str && str.contains("_")) {
            int i = str.indexOf("_");
            char ch = str.charAt(i + 1);
            char newCh = (ch + "").substring(0, 1).toUpperCase().toCharArray()[0];
            String newStr = str.replace(str.charAt(i + 1), newCh);
            String newStr2 = newStr.replace("_", "");
            return newStr2;
        }
        return str;
    }

    public static String underlineToHump(String para) {
        String[] a;
        StringBuilder result = new StringBuilder();
        for (String s : a = para.split("_")) {
            if (result.length() == 0) {
                result.append(s.toLowerCase());
                continue;
            }
            result.append(s.substring(0, 1).toUpperCase());
            result.append(s.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String humpToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toUpperCase();
    }

    public static void main(String[] args) {
        String s = ReflexUtil.humpToUnderline("asdWsdfFls");
        System.out.println(s);
    }
}

