/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.util;

import java.io.Serializable;
import org.springframework.validation.BindingResult;

public class Result<T>
implements Serializable {
    private int code;
    private String message;
    private Object data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(int code) {
        this.code = code;
    }

    public Result success(Object data) {
        this.code = 0;
        this.message = "\u6210\u529f";
        this.data = data;
        return this;
    }

    public Result success() {
        this.code = 0;
        this.message = "\u6210\u529f";
        return this;
    }

    public Result failed() {
        this.code = -1;
        this.message = "\u5931\u8d25";
        return this;
    }

    public Result failed(String msg) {
        this.code = -1;
        this.message = msg;
        return this;
    }

    public Result failed(int code, String msg) {
        this.code = code;
        this.message = msg;
        return this;
    }

    public Result validateFailed(String message) {
        this.code = 3;
        this.message = message;
        return this;
    }

    public Result unauthorized(String message) {
        this.code = 10021;
        this.message = message;
        return this;
    }

    public Result forbidden(String message) {
        this.code = 403;
        this.message = message;
        return this;
    }

    public Result validateFailed(BindingResult result) {
        this.validateFailed(result.getFieldError().getDefaultMessage());
        return this;
    }

    public Result<T> error(int code, String msg) {
        this.code = code;
        this.message = msg;
        return this;
    }

    public Result<T> error(int code) {
        this.code = code;
        return this;
    }

    public Result<T> error(String msg) {
        this.code = 500;
        this.message = msg;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

