/*
 * Decompiled with CFR 0.152.
 */
package com.hld.query.wrapper;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.hld.query.exception.CommonException;
import com.hld.query.params.FilterType;
import com.hld.query.params.ICondition;
import com.hld.query.params.IFilter;
import com.hld.query.params.IOrderBy;
import com.hld.query.params.OrderType;
import com.hld.query.params.QueryOptions;
import com.hld.query.util.QueryUtils;
import com.hld.query.util.ReflexUtil;
import com.hld.query.util.SqlFilter;
import com.hld.query.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonWrapper<T>
extends AbstractWrapper<T, String, CommonWrapper<T>>
implements Query<CommonWrapper<T>, T, String> {
    private static final Logger log = LoggerFactory.getLogger(CommonWrapper.class);
    private SharedString sqlSelect = new SharedString();
    private List<IFilter> filters = null;
    private List<String> columns;
    private List<IOrderBy> orderBys;
    private Long curPage = null;
    private Long limit = null;
    private String firstSql = null;

    public CommonWrapper() {
        this(null);
    }

    protected CommonWrapper<T> instance() {
        return null;
    }

    public CommonWrapper(T entity) {
        super.setEntity(entity);
        super.initNeed();
    }

    public CommonWrapper(T entity, QueryOptions options) {
        super.setEntity(entity);
        super.initNeed();
        if (options != null) {
            this.filters = options.getFilters();
            this.columns = options.getColumns();
            this.orderBys = options.getOrderBys();
            this.curPage = options.getCurPage();
            this.limit = options.getLimit();
            this.firstSql = options.getFirstSql();
            this.splitColumns(this, this.columns);
            this.splitFilters(this, this.filters, false);
            this.splitOrderBy(this, this.orderBys);
        }
    }

    public CommonWrapper(QueryOptions options) {
        if (options != null) {
            this.filters = options.getFilters();
            this.columns = options.getColumns();
            this.orderBys = options.getOrderBys();
            this.curPage = options.getCurPage();
            this.limit = options.getLimit();
            this.firstSql = options.getFirstSql();
            this.splitColumns(this, this.columns);
            this.splitFilters(this, this.filters, false);
            this.splitOrderBy(this, this.orderBys);
        }
    }

    public List<IFilter> getFilters() {
        return this.filters;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<IOrderBy> getOrderBys() {
        return this.orderBys;
    }

    public Long getCurPage() {
        return this.curPage;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getFirstSql() {
        return this.firstSql;
    }

    public void setFirstSql(String firstSql) {
        this.firstSql = firstSql;
    }

    private void splitOrderBy(CommonWrapper<T> wrapper, List<IOrderBy> orderBys) {
        if (orderBys != null && orderBys.size() > 0) {
            int length = orderBys.size();
            for (int i = 0; i < length; ++i) {
                IOrderBy orderBy = orderBys.get(i);
                orderBy.setOrderByName(SqlFilter.sqlInject(orderBy.getOrderByName()));
                if (OrderType.ASC == orderBy.getOrderByType()) {
                    wrapper.orderByAsc(orderBy.getOrderByName());
                    continue;
                }
                wrapper.orderByDesc(orderBy.getOrderByName());
            }
        }
    }

    private void splitColumns(CommonWrapper<T> wrapper, List<String> columns) {
        if (columns != null && columns.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("common wrapper columns:[{}]", (Object)columns.toString());
            }
            wrapper.select(columns.toArray(new String[columns.size()]));
        } else {
            wrapper.select(" * ");
        }
    }

    public CommonWrapper(T entity, String ... columns) {
        super.setEntity(entity);
        super.initNeed();
        this.select(columns);
    }

    private CommonWrapper(T entity, Class<T> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment) {
        super.setEntity(entity);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
    }

    public CommonWrapper<T> select(String ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.sqlSelect.setStringValue(String.join((CharSequence)",", columns));
        }
        return (CommonWrapper)this.typedThis;
    }

    public CommonWrapper<T> select(Predicate<TableFieldInfo> predicate) {
        return null;
    }

    public CommonWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        return null;
    }

    public String getSqlSelect() {
        return this.sqlSelect.getStringValue();
    }

    private CommonWrapper<T> splitFilters(CommonWrapper<T> wrapper, List<IFilter> filters, boolean isSecond) {
        if (filters == null || filters.size() <= 0) {
            return wrapper;
        }
        log.info("common wrapper split filters isSecond:[{}]", (Object)isSecond);
        int size = filters.size();
        for (int i = 0; i < size; ++i) {
            List<Object> filterValues;
            IFilter filter = filters.get(i);
            if (filter == null) continue;
            if (filter.getFilterType() == null) {
                filter.setFilterType(FilterType.DEFAULT);
            }
            log.info("common wrapper split filters type:[{}]", (Object)filter.getFilterType());
            if (filter.getFilterType() == FilterType.OR_NEW || filter.getFilterType() == FilterType.AND_NEW) {
                CommonWrapper<T> childWrapper = this.splitFilters(new CommonWrapper<T>(), filter.getChildren(), true);
                String sql = QueryUtils.splitWhereSql(childWrapper.getSqlSegment(), childWrapper.getParamNameValuePairs());
                if (filter.getFilterType() == FilterType.OR_NEW) {
                    wrapper.or();
                }
                wrapper.apply(" (" + sql + " )", new Object[0]);
                continue;
            }
            if (filter.getFilterName() == null) continue;
            if (filter.getFilterType() == FilterType.OR) {
                wrapper.or();
            } else {
                wrapper.and(true);
            }
            if (filter.getCondition() == null) {
                filter.setCondition(ICondition.EQUAL);
            }
            if ((filterValues = filter.getFilterValue()) != null && filterValues.size() > 0) {
                if (isSecond && i != 0) {
                    if (filter.getFilterType() == FilterType.OR) {
                        wrapper.or();
                    } else {
                        wrapper.and(true);
                    }
                }
                this.splitCondition(wrapper, filter, filterValues, isSecond);
                continue;
            }
            this.splitCondition2(wrapper, filter);
        }
        return wrapper;
    }

    private void splitCondition(CommonWrapper<T> wrapper, IFilter filter, List<Object> filterValues, boolean isSecond) {
        String filterName = filter.getFilterName();
        filterName = SqlFilter.sqlInject(filterName);
        filterValues = SqlFilter.sqlInjectObject(filterValues);
        if (filter.getCondition() == ICondition.EQUAL) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, "=");
            } else {
                wrapper.eq(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.UN_EQUAL) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, "!=");
            } else {
                wrapper.ne(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.LIKE) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.LIKE) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            for (int j = 0; j < filterValues.size(); ++j) {
                Object filterValue = filterValues.get(j);
                wrapper.like(filterValue != null, ReflexUtil.humpToUnderline(filterName), filterValue != null ? this.splitSingleQuote(filterValue.toString()) : "");
                if (!isSecond || j == filterValues.size() - 1) continue;
                if (filter.getFilterType() == FilterType.OR) {
                    wrapper.or();
                    continue;
                }
                wrapper.and(true);
            }
        } else if (filter.getCondition() == ICondition.LEFT_LIKE) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.LEFT_LIKE) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            for (int j = 0; j < filterValues.size(); ++j) {
                Object filterValue = filterValues.get(j);
                wrapper.likeLeft(filterValue != null, ReflexUtil.humpToUnderline(filterName), filterValue != null ? this.splitSingleQuote(filterValue.toString()) : "");
                if (!isSecond || j == filterValues.size() - 1) continue;
                if (filter.getFilterType() == FilterType.OR) {
                    wrapper.or();
                    continue;
                }
                wrapper.and(true);
            }
        } else if (filter.getCondition() == ICondition.RIGHT_LIKE) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.RIGHT_LIKE) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            for (int j = 0; j < filterValues.size(); ++j) {
                Object filterValue = filterValues.get(j);
                wrapper.likeRight(filterValue != null, ReflexUtil.humpToUnderline(filterName), filterValue != null ? this.splitSingleQuote(filterValue.toString()) : "");
                if (!isSecond || j == filterValues.size() - 1) continue;
                if (filter.getFilterType() == FilterType.OR) {
                    wrapper.or();
                    continue;
                }
                wrapper.and(true);
            }
        } else if (filter.getCondition() == ICondition.NO_LIKE) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NO_LIKE) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            for (int j = 0; j < filterValues.size(); ++j) {
                Object filterValue = filterValues.get(j);
                wrapper.notLike(filterValue != null, ReflexUtil.humpToUnderline(filterName), filterValue != null ? this.splitSingleQuote(filterValue.toString()) : "");
                if (!isSecond || j == filterValues.size() - 1) continue;
                if (filter.getFilterType() == FilterType.OR) {
                    wrapper.or();
                    continue;
                }
                wrapper.and(true);
            }
        } else if (filter.getCondition() == ICondition.IN) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.IN) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.in(ReflexUtil.humpToUnderline(filterName), filterValues);
        } else if (filter.getCondition() == ICondition.NO_IN) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NO_IN) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.notIn(ReflexUtil.humpToUnderline(filterName), filterValues);
        } else if (filter.getCondition() == ICondition.GE) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, ">=");
            } else {
                wrapper.ge(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.LE) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, "<=");
            } else {
                wrapper.le(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.GT) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, ">");
            } else {
                wrapper.gt(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.LT) {
            if (this.isDateCondition(filter)) {
                this.splitDateCondition(wrapper, filter, "<");
            } else {
                wrapper.lt(filterValues.get(0) != null, ReflexUtil.humpToUnderline(filterName), filterValues.get(0) == null ? "" : this.splitSingleQuote(filterValues.get(0).toString()));
            }
        } else if (filter.getCondition() == ICondition.NOT_NULL) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NOT_NULL) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.isNotNull(ReflexUtil.humpToUnderline(filterName));
        } else if (filter.getCondition() == ICondition.NULL) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NULL) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.isNull(ReflexUtil.humpToUnderline(filterName));
        } else if (filter.getCondition() == ICondition.BETWEEN) {
            if (filterValues.size() < 2) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.BETWEEN) + ") \u9700\u4e24\u4e2a\u53c2\u6570\u503c");
            }
            Object start = filterValues.get(0);
            Object end = filterValues.get(1);
            wrapper.between(ReflexUtil.humpToUnderline(filterName), start, end);
        } else if (filter.getCondition() == ICondition.NOT_BETWEEN) {
            if (filterValues.size() < 2) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NOT_BETWEEN) + ") \u9700\u4e24\u4e2a\u53c2\u6570\u503c");
            }
            Object start = filterValues.get(0);
            Object end = filterValues.get(1);
            wrapper.notBetween(ReflexUtil.humpToUnderline(filterName), start, end);
        }
    }

    private void splitCondition2(CommonWrapper<T> wrapper, IFilter filter) {
        String filterName = filter.getFilterName();
        filterName = SqlFilter.sqlInject(filterName);
        if (filter.getCondition() == ICondition.NOT_NULL) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NOT_NULL) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.isNotNull(ReflexUtil.humpToUnderline(filterName));
        } else if (filter.getCondition() == ICondition.NULL) {
            if (this.isDateCondition(filter)) {
                throw new CommonException(10003, "\u5f53\u524dcondition(" + (Object)((Object)ICondition.NULL) + ") \u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b\u53c2\u6570");
            }
            wrapper.isNull(ReflexUtil.humpToUnderline(filterName));
        } else {
            wrapper.eq("1", 1);
        }
    }

    private boolean isDateCondition(IFilter filter) {
        return filter != null && !StringUtils.isEmpty(filter.getDateFormat());
    }

    private void splitDateCondition(CommonWrapper<T> wrapper, IFilter filter, String condition) {
        StringBuilder builder = new StringBuilder();
        builder.append("date_format(").append(ReflexUtil.humpToUnderline(filter.getFilterName())).append(",'").append(filter.getDateFormat()).append("') ").append(condition).append(" {0}");
        String value = filter.getFilterValue().get(0) + "";
        wrapper.apply(builder.toString(), new Object[]{value});
    }

    private String splitSingleQuote(String s) {
        return s;
    }

    private List<String> splitSingleQuotes(List<Object> objects) {
        if (objects == null || objects.size() <= 0) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> list = new ArrayList<String>(objects.size());
        for (Object o : objects) {
            list.add("'" + o.toString() + "'");
        }
        return list;
    }
}

