/*
 * Decompiled with CFR 0.152.
 */
package com.github.gg_a.tuple;

import com.github.gg_a.exception.AliasDuplicateException;
import com.github.gg_a.exception.AliasNotFoundException;
import com.github.gg_a.exception.AliasNotSetException;
import com.github.gg_a.exception.NumberOfAliasesException;
import com.github.gg_a.tuple.Tuple;
import com.github.gg_a.tuple.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TupleBase
implements Tuple {
    private static final long serialVersionUID = 10065917090L;
    private List<String> aliasList = new ArrayList<String>();
    private Map<String, Integer> alias_index = new HashMap<String, Integer>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tuple alias(String ... aliases) {
        if (this.arity() == 0) {
            throw new UnsupportedOperationException("`alias` method is unsupported in Tuple0. Because Tuple0 is empty tuple. Tuple0\u4e0d\u652f\u6301\u8c03\u7528alias\u65b9\u6cd5\uff0c\u56e0\u4e3aTuple0\u662f\u4e00\u4e2a\u7a7a\u5143\u7ec4\u3002");
        }
        if (aliases == null) {
            if (this.arity() != 1) throw new NumberOfAliasesException("aliases' length is not equals " + this.arity() + ". \u53c2\u6570aliases\u7684\u957f\u5ea6\u4e0d\u7b49\u4e8e" + this.arity() + "\u3002");
            this.alias_index.clear();
            this.aliasList.clear();
            this.putToMap(null, 0);
            return this;
        } else {
            if (this.arity() != aliases.length) {
                throw new NumberOfAliasesException("aliases' length is not equals " + this.arity() + ". \u53c2\u6570aliases\u7684\u957f\u5ea6\u4e0d\u7b49\u4e8e" + this.arity() + "\u3002");
            }
            this.alias_index.clear();
            this.aliasList.clear();
            for (int i = 0; i < aliases.length; ++i) {
                this.putToMap(aliases[i], i);
            }
        }
        return this;
    }

    @Override
    public List<String> getAliases() {
        return new ArrayList<String>(this.aliasList);
    }

    @Override
    public <R> R __(String alias) {
        if (this.alias_index.containsKey(alias)) {
            return this.element(this.alias_index.get(alias));
        }
        throw new AliasNotFoundException("the alias `" + alias + "` not found.  \u522b\u540d`" + alias + "`\u6ca1\u6709\u627e\u5230\u3002");
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.arity() != 0 && this.aliasList.contains(alias);
    }

    @Override
    public <R> Tuple2<String, R> elementWithAlias(int n) {
        if (n >= this.arity()) {
            throw new IndexOutOfBoundsException("Index out of range: " + n + ", Size: " + this.arity());
        }
        if (this.aliasList.isEmpty()) {
            throw new AliasNotSetException("The aliases not set. Please call `aliases` method first. \u522b\u540d\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8c03\u7528aliases\u65b9\u6cd5\u8bbe\u7f6e\u522b\u540d\u3002");
        }
        String alias = this.aliasList.get(n);
        Object element = this.element(n);
        return new Tuple2(alias, element);
    }

    public String toString() {
        if (this.arity() == 0) {
            return "()";
        }
        ArrayList<String> strList = new ArrayList<String>();
        for (int i = 0; i < this.arity(); ++i) {
            strList.add(this._nStr(this.element(i)));
        }
        return this.alias_index.isEmpty() ? "(" + String.join((CharSequence)", ", strList) + ")" : "(" + this.concatElement(strList) + ")";
    }

    private void putToMap(String alias, int index) {
        if (this.alias_index.containsKey(alias)) {
            throw new AliasDuplicateException("the alias `" + alias + "` is existed. \u522b\u540d `" + alias + "` \u5df2\u7ecf\u5b58\u5728\u3002 ");
        }
        this.alias_index.put(alias, index);
        this.aliasList.add(alias);
    }

    private String concatElement(List<String> strList) {
        ArrayList<String> tempStrList = new ArrayList<String>();
        for (int i = 0; i < strList.size(); ++i) {
            String alias = this.aliasList.get(i);
            alias = alias == null ? "`null`" : alias;
            tempStrList.add(alias + ": " + strList.get(i));
        }
        return String.join((CharSequence)", ", tempStrList);
    }

    private <R> String _nStr(R _n) {
        String nstr;
        String string = nstr = _n == null ? "null" : _n.toString();
        if (_n instanceof String) {
            nstr = "\"" + nstr + "\"";
        }
        return nstr;
    }
}

