package com.github.missthee.mybatis.generator.plugins.custom;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * addStaticPropertyName, addPropertyComment, addPropertySwaggerAnnotation
 */
public class LombokPlugin extends PluginAdapter {

    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    /**
     * 拦截 普通字段
     */
    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass,
                                                 IntrospectedTable introspectedTable) {
        addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    /**
     * 拦截 主键
     */
    @Override
    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass,
                                                 IntrospectedTable introspectedTable) {
        addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    /**
     * 拦截 blob 类型字段
     */
    @Override
    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    /**
     * Model增加注解
     */
    private void addCustomCode(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        //添加依赖
        topLevelClass.addImportedType("lombok.Data");
        topLevelClass.addImportedType("lombok.experimental.Accessors");

        //注解
        topLevelClass.addAnnotation("@Data");
        topLevelClass.addAnnotation("@Accessors(chain = true)");
        String addStaticPropertyName = this.properties.getProperty("addStaticPropertyName");
        if ("true".equals(addStaticPropertyName)) {
            //添加字名段静变量
            addStaticPropertyName(topLevelClass, introspectedTable);
        }
    }

    private void addStaticPropertyName(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            String nameInModel = introspectedColumn.getJavaProperty();
            String nameInDB = introspectedColumn.getActualColumnName();
            {
                Field field = new Field();
                field.setName(nameInDB.toUpperCase());
                field.setVisibility(JavaVisibility.PUBLIC);
                field.setInitializationString("\"" + nameInModel + "\"");
                field.setFinal(true);
                field.setStatic(true);
                field.setType(new FullyQualifiedJavaType("String"));
                topLevelClass.addField(field);
            }
            {
                Field field = new Field();
                field.setName("DB_" + nameInDB.toUpperCase());
                field.setVisibility(JavaVisibility.PUBLIC);
                field.setInitializationString("\"" + nameInDB + "\"");
                field.setFinal(true);
                field.setStatic(true);
                field.setType(new FullyQualifiedJavaType("String"));
                topLevelClass.addField(field);
            }
        }
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        this.comment(field, introspectedTable, introspectedColumn);
        return true;
    }

    //Model属性上面的注释
    private void comment(JavaElement element, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        element.getJavaDocLines().clear();
        String addPropertyComment = this.properties.getProperty("addPropertyComment");
        if ("true".equals(addPropertyComment)) {
            String remark = introspectedColumn.getRemarks();
            if (remark != null && remark.length() > 1) {
                element.addJavaDocLine("//" + remark);
            }
        }
        String addPropertySwaggerAnnotation = this.properties.getProperty("addPropertySwaggerAnnotation");
        if ("true".equals(addPropertySwaggerAnnotation)) {
            String remark = introspectedColumn.getRemarks();
            if (remark != null && remark.length() > 1) {
                element.addJavaDocLine("@ApiModelProperty(value=\"" + remark + "\")");
            }
        }
    }

    /**
     * Getter
     */
    @Override
    public boolean modelGetterMethodGenerated(Method method,
                                              TopLevelClass topLevelClass,
                                              IntrospectedColumn introspectedColumn,
                                              IntrospectedTable introspectedTable,
                                              ModelClassType modelClassType) {
        return false;
    }

    /**
     * Setter
     */
    @Override
    public boolean modelSetterMethodGenerated(Method method,
                                              TopLevelClass topLevelClass,
                                              IntrospectedColumn introspectedColumn,
                                              IntrospectedTable introspectedTable,
                                              ModelClassType modelClassType) {
        return false;
    }


    //取消生成Base_Column_List
    public boolean sqlMapBaseColumnListElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        if (false) {
            document.getRootElement().addElement(new TextElement(""));
            document.getRootElement().addElement(new TextElement("<!-- ### 以上代码由MBG + CommentPlugin自动生成, 生成时间: " + (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(new Date()) + " ### -->\n\n\n"));
            document.getRootElement().addElement(new TextElement("<!-- Your codes goes here!!! -->"));
            document.getRootElement().addElement(new TextElement(""));
        }
        return true;
    }

    //生成mapper.java 接口方法
    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        addMapperClassAnnotation(interfaze);
        return true;
    }

    //添加@Component注解
    private void addMapperClassAnnotation(Interface interfaze) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Component"));
        String addPropertySwaggerAnnotation = this.properties.getProperty("addMapperClassComponentAnnotation");
        if ("true".equals(addPropertySwaggerAnnotation)) {
            //添加domain的注解
            interfaze.addAnnotation("@Component");
        }
    }
    //    public boolean sqlMapResultMapWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.commentResultMap(element, introspectedTable);
//        return true;
//    }
//
//    public boolean sqlMapResultMapWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.commentResultMap(element, introspectedTable);
//        return true;
//    }
//
//    void commentResultMap(XmlElement element, IntrospectedTable introspectedTable) {
//        List<Element> es = element.getElements();
//        if (!es.isEmpty()) {
//            String alias = introspectedTable.getTableConfiguration().getAlias();
//            int aliasLen = -1;
//            if (alias != null) {
//                aliasLen = alias.length() + 1;
//            }
//
//            Iterator<Element> it = es.iterator();
//            HashMap map = new HashMap();
//
//            while (true) {
//                while (it.hasNext()) {
//                    Element e = (Element) it.next();
//                    if (e instanceof TextElement) {
//                        it.remove();
//                    } else {
//                        XmlElement el = (XmlElement) e;
//                        List<Attribute> as = el.getAttributes();
//                        if (!as.isEmpty()) {
//                            String col = null;
//                            Iterator i$ = as.iterator();
//
//                            while (i$.hasNext()) {
//                                Attribute a = (Attribute) i$.next();
//                                if (a.getName().equalsIgnoreCase("column")) {
//                                    col = a.getValue();
//                                    break;
//                                }
//                            }
//
//                            if (col != null) {
//                                if (aliasLen > 0) {
//                                    col = col.substring(aliasLen);
//                                }
//
//                                IntrospectedColumn ic = introspectedTable.getColumn(col);
//                                if (ic != null) {
//                                    StringBuilder sb = new StringBuilder();
//                                    if (ic.getRemarks() != null && ic.getRemarks().length() > 1) {
//                                        sb.append("<!-- ");
//                                        sb.append(ic.getRemarks());
//                                        sb.append(" -->");
//                                        map.put(el, new TextElement(sb.toString()));
//                                    }
//                                }
//                            }
//                        }
//                    }
//                }
//
//                if (map.isEmpty()) {
//                    return;
//                }
//
//                Set<Element> set = map.keySet();
//                Iterator i$ = set.iterator();
//
//                while (i$.hasNext()) {
//                    Element e = (Element) i$.next();
//                    int id = es.indexOf(e);
//                    es.add(id, (Element) map.get(e));
////                    es.add(id, new TextElement(""));
//                }
//
//                return;
//            }
//        }
//    }

//    public boolean sqlMapInsertElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.removeAttribute(element.getAttributes(), "parameterType");
//        return true;
//    }
//
//    public boolean sqlMapInsertSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.removeAttribute(element.getAttributes(), "parameterType");
//        return true;
//    }
//
//    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.removeAttribute(element.getAttributes(), "parameterType");
//        return true;
//    }
//
//    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.removeAttribute(element.getAttributes(), "parameterType");
//        return true;
//    }
//
//    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
//        this.removeAttribute(element.getAttributes(), "parameterType");
//        return true;
//    }

//    private void removeAttribute(List<Attribute> as, String name) {
//        if (!as.isEmpty()) {
//            Iterator it = as.iterator();
//
//            Attribute attr;
//            do {
//                if (!it.hasNext()) {
//                    return;
//                }
//
//                attr = (Attribute) it.next();
//            } while (!attr.getName().equalsIgnoreCase(name));
//
//            it.remove();
//        }
//    }
}
