/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.mybatis.generator.plugins.custom;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class LombokPlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addCustomCode(topLevelClass, introspectedTable);
        return true;
    }

    private void addCustomCode(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType("lombok.Data");
        topLevelClass.addImportedType("lombok.experimental.Accessors");
        topLevelClass.addAnnotation("@Data");
        topLevelClass.addAnnotation("@Accessors(chain = true)");
        String addStaticPropertyName = this.properties.getProperty("addStaticPropertyName");
        if ("true".equals(addStaticPropertyName)) {
            this.addStaticPropertyName(topLevelClass, introspectedTable);
        }
    }

    private void addStaticPropertyName(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (IntrospectedColumn introspectedColumn : introspectedTable.getAllColumns()) {
            String nameInModel = introspectedColumn.getJavaProperty();
            String nameInDB = introspectedColumn.getActualColumnName();
            Field field = new Field();
            field.setName(nameInDB.toUpperCase());
            field.setVisibility(JavaVisibility.PUBLIC);
            field.setInitializationString("\"" + nameInModel + "\"");
            field.setFinal(true);
            field.setStatic(true);
            field.setType(new FullyQualifiedJavaType("String"));
            topLevelClass.addField(field);
            field = new Field();
            field.setName("DB_" + nameInDB.toUpperCase());
            field.setVisibility(JavaVisibility.PUBLIC);
            field.setInitializationString("\"" + nameInDB + "\"");
            field.setFinal(true);
            field.setStatic(true);
            field.setType(new FullyQualifiedJavaType("String"));
            topLevelClass.addField(field);
        }
    }

    public boolean modelFieldGenerated(Field field, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        this.comment((JavaElement)field, introspectedTable, introspectedColumn);
        return true;
    }

    private void comment(JavaElement element, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        String remark;
        String addPropertySwaggerAnnotation;
        String remark2;
        element.getJavaDocLines().clear();
        String addPropertyComment = this.properties.getProperty("addPropertyComment");
        if ("true".equals(addPropertyComment) && (remark2 = introspectedColumn.getRemarks()) != null && remark2.length() > 1) {
            element.addJavaDocLine("//" + remark2);
        }
        if ("true".equals(addPropertySwaggerAnnotation = this.properties.getProperty("addPropertySwaggerAnnotation")) && (remark = introspectedColumn.getRemarks()) != null && remark.length() > 1) {
            element.addJavaDocLine("@ApiModelProperty(value=\"" + remark + "\")");
        }
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        return false;
    }

    public boolean sqlMapBaseColumnListElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        return false;
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addMapperClassAnnotation(interfaze);
        return true;
    }

    private void addMapperClassAnnotation(Interface interfaze) {
        interfaze.addImportedType(new FullyQualifiedJavaType("org.springframework.stereotype.Component"));
        String addPropertySwaggerAnnotation = this.properties.getProperty("addMapperClassComponentAnnotation");
        if ("true".equals(addPropertySwaggerAnnotation)) {
            interfaze.addAnnotation("@Component");
        }
    }
}

