/*
 * Decompiled with CFR 0.152.
 */
package com.github;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.type.NullType;

public class PyBuiltin {
    private PyBuiltin() {
    }

    public static Integer abs(Integer n) {
        return Math.abs(n);
    }

    public static Long abs(Long n) {
        return Math.abs(n);
    }

    public static Double abs(Double n) {
        return Math.abs(n);
    }

    public static Float abs(Float n) {
        return Float.valueOf(Math.abs(n.floatValue()));
    }

    public static Short abs(Short n) {
        return Short.valueOf(String.valueOf(Math.abs(n.shortValue())));
    }

    public static Byte abs(Byte n) {
        return Byte.valueOf(String.valueOf(Math.abs(n.byteValue())));
    }

    public static BigDecimal abs(BigDecimal n) {
        return n.abs();
    }

    public static BigInteger abs(BigInteger n) {
        return n.abs();
    }

    public static void print(Object o) {
        PyBuiltin.print(o, "\n");
    }

    public static void print(Object o, String end) {
        System.out.print(String.valueOf(o) + end);
    }

    public static int id(Object o) {
        return PyBuiltin.hash(o);
    }

    public static int len(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return c.size();
    }

    public static int len(Map m) {
        if (m == null) {
            throw new NullPointerException();
        }
        return m.size();
    }

    public static int len(Object[] o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return o.length;
    }

    public static int len(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return s.length();
    }

    public static String str(Object o) {
        return String.valueOf(o);
    }

    public static int int_(Object o) {
        if (o == null) {
            throw new NullPointerException("Null can not cast to Integer!");
        }
        return Integer.valueOf(PyBuiltin.str(o));
    }

    public static Boolean bool(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return PyBuiltin.bool((Boolean)o);
        }
        if (o instanceof String) {
            return PyBuiltin.bool((String)o);
        }
        if (o instanceof Collection) {
            return PyBuiltin.bool((Collection)o);
        }
        if (o instanceof Map) {
            return PyBuiltin.bool((Map)o);
        }
        return true;
    }

    public static Boolean bool(Boolean b) {
        return b == null ? false : b;
    }

    public static Boolean bool(String s) {
        return s != null && s != "";
    }

    public static Boolean bool(Collection c) {
        return c != null && !c.isEmpty();
    }

    public static Boolean bool(Map m) {
        return m != null && !m.isEmpty();
    }

    public static int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static <T> T max(Map<T, Object> m, Comparator<T> cmp) {
        return Collections.max(m.keySet(), cmp);
    }

    public static <T> T max(Map<T, Object> m) {
        return Collections.max(m.keySet());
    }

    public static <T> T max(Collection<T> c, Comparator<T> cmp) {
        return Collections.max(c, cmp);
    }

    public static <T> T max(Collection<T> c) {
        return Collections.max(c);
    }

    public static <T> T min(Map<T, Object> m, Comparator<T> cmp) {
        return Collections.min(m.keySet(), cmp);
    }

    public static <T> T min(Map<T, Object> m) {
        return Collections.min(m.keySet());
    }

    public static <T> T min(Collection<T> c, Comparator<T> cmp) {
        return Collections.min(c, cmp);
    }

    public static <T> T min(Collection<T> c) {
        return Collections.min(c);
    }

    public static <E> Set<E> set(Collection<E> c) {
        return PyBuiltin.set(c, false);
    }

    public static <K, V> Set<K> set(Map<K, V> m) {
        return PyBuiltin.set(m, false);
    }

    public static <E> Set<E> set(E[] o) {
        return PyBuiltin.set(o, false);
    }

    public static Set<String> set(String s) {
        return PyBuiltin.set(s, false);
    }

    public static Set<String> set(String c, boolean needThreadSafe) {
        List<String> temp = Arrays.asList(c.split(""));
        return needThreadSafe ? new CopyOnWriteArraySet<String>(temp) : new HashSet<String>(temp);
    }

    public static <E> Set<E> set(Collection<E> c, boolean needThreadSafe) {
        return needThreadSafe ? new CopyOnWriteArraySet<E>(c) : new HashSet<E>(c);
    }

    public static <K, V> Set<K> set(Map<K, V> m, boolean needThreadSafe) {
        return needThreadSafe ? new CopyOnWriteArraySet<K>(m.keySet()) : new HashSet<K>(m.keySet());
    }

    public static <E> Set<E> set(E[] o, boolean needThreadSafe) {
        List<E> temp = Arrays.asList(o);
        return needThreadSafe ? new CopyOnWriteArraySet<E>(temp) : new HashSet<E>(temp);
    }

    public static <E> List<E> list(Collection<E> c) {
        return PyBuiltin.list(c, false);
    }

    public static <K, V> List<K> list(Map<K, V> m) {
        return PyBuiltin.list(m, false);
    }

    public static <E> List<E> list(E[] o) {
        return PyBuiltin.list(o, false);
    }

    public static List<String> list(String s) {
        return PyBuiltin.list(s, false);
    }

    public static List<String> list(String c, boolean needThreadSafe) {
        List<String> temp = Arrays.asList(c.split(""));
        return needThreadSafe ? new CopyOnWriteArrayList<String>(temp) : new ArrayList<String>(temp);
    }

    public static <E> List<E> list(Collection<E> c, boolean needThreadSafe) {
        return needThreadSafe ? new CopyOnWriteArrayList<E>(c) : new ArrayList<E>(c);
    }

    public static <K, V> List<K> list(Map<K, V> m, boolean needThreadSafe) {
        return needThreadSafe ? new CopyOnWriteArrayList<K>(m.keySet()) : new ArrayList<K>(m.keySet());
    }

    public static <E> List<E> list(E[] o, boolean needThreadSafe) {
        List<E> temp = Arrays.asList(o);
        return needThreadSafe ? new CopyOnWriteArrayList<E>(temp) : new ArrayList<E>(temp);
    }

    public static <T extends Number> T sum(T[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        if (arr.length == 0) {
            return (T)new Integer(0);
        }
        return PyBuiltin.sum(Arrays.asList(arr));
    }

    public static <T extends Number> T sum(Map<T, Object> m) {
        if (m == null) {
            throw new NullPointerException();
        }
        if (m.isEmpty()) {
            return (T)new Integer(0);
        }
        return PyBuiltin.sum(m.keySet());
    }

    public static <T extends Number> T sum(Collection<T> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return (T)new Integer(0);
        }
        Number result = null;
        for (Number t : c) {
            Number tempT;
            Number temp;
            if (t instanceof Integer) {
                temp = result == null ? Integer.valueOf(0) : (Integer)result;
                tempT = (Integer)t;
                result = temp = Integer.valueOf((Integer)temp + (Integer)tempT);
            }
            if (t instanceof Long) {
                temp = result == null ? Long.valueOf(0L) : (Long)result;
                tempT = (Long)t;
                result = temp = Long.valueOf((Long)temp + (Long)tempT);
            }
            if (t instanceof Double) {
                temp = result == null ? Double.valueOf(0.0) : (Double)result;
                tempT = (Double)t;
                result = temp = Double.valueOf((Double)temp + (Double)tempT);
            }
            if (t instanceof Float) {
                temp = result == null ? Float.valueOf(0.0f) : (Float)result;
                tempT = (Float)t;
                result = temp = Float.valueOf(((Float)temp).floatValue() + ((Float)tempT).floatValue());
            }
            if (t instanceof BigInteger) {
                temp = result == null ? new BigInteger("0") : (BigInteger)result;
                tempT = (BigInteger)t;
                result = temp = ((BigInteger)temp).add((BigInteger)tempT);
            }
            if (t instanceof BigDecimal) {
                temp = result == null ? new BigDecimal("0") : (BigDecimal)result;
                tempT = (BigDecimal)t;
                result = temp = ((BigDecimal)temp).add((BigDecimal)tempT);
            }
            if (t instanceof Short) {
                temp = result == null ? Integer.valueOf(0) : (Integer)result;
                tempT = (Short)t;
                result = temp = Integer.valueOf((Integer)temp + (Short)tempT);
            }
            if (!(t instanceof Byte)) continue;
            temp = result == null ? Integer.valueOf(0) : (Integer)result;
            tempT = (Byte)t;
            result = temp = Integer.valueOf((Integer)temp + (Byte)tempT);
        }
        return (T)result;
    }

    public static Class type(Object o) {
        return o == null ? NullType.class : o.getClass();
    }

    public static Boolean any(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return PyBuiltin.bool(o);
    }

    public static Boolean any(Collection c) {
        if (!PyBuiltin.bool(c).booleanValue()) {
            return false;
        }
        boolean result = false;
        for (Object o : c) {
            if (!PyBuiltin.bool(o).booleanValue()) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Boolean any(Map m) {
        if (!PyBuiltin.bool(m).booleanValue()) {
            return false;
        }
        return PyBuiltin.any(m.keySet());
    }

    public static Boolean all(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Collection) {
            return PyBuiltin.all((Collection)o);
        }
        if (o instanceof Map) {
            return PyBuiltin.all((Map)o);
        }
        return true;
    }

    public static Boolean all(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return true;
        }
        Boolean result = true;
        for (Object o : c) {
            if (PyBuiltin.bool(o).booleanValue()) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Boolean all(Map m) {
        if (m == null) {
            throw new NullPointerException();
        }
        if (m.isEmpty()) {
            return true;
        }
        return PyBuiltin.all(m.keySet());
    }

    public static <E> Collection<E> filter(Predicate<E> filter, Collection<E> source) {
        if (source instanceof List) {
            return PyBuiltin.filter(filter, (List)source);
        }
        if (source instanceof Set) {
            return PyBuiltin.filter(filter, (Set)source);
        }
        return null;
    }

    public static <E> List<E> filter(Predicate<E> filter, List<E> source) {
        return source.stream().filter(filter).collect(Collectors.toList());
    }

    public static <E> Set<E> filter(Predicate<E> filter, Set<E> source) {
        return source.stream().filter(filter).collect(Collectors.toSet());
    }

    public static <E, R> Collection<R> map(Function<E, R> mapper, Collection<E> source) {
        if (source instanceof List) {
            return PyBuiltin.map(mapper, (List)source);
        }
        if (source instanceof Set) {
            return PyBuiltin.map(mapper, (Set)source);
        }
        return null;
    }

    public static <E, R> List<R> map(Function<E, R> mapper, List<E> source) {
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public static <E, R> Set<R> map(Function<E, R> mapper, Set<E> source) {
        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    public static Double pow(Number a, Number b) {
        if (a == null || b == null) {
            throw new NullPointerException("The number of square calculations can't be null!");
        }
        double ta = PyBuiltin.double_(a);
        double tb = PyBuiltin.double_(b);
        return Math.pow(ta, tb);
    }

    public static Long long_(Number n) {
        if (n == null) {
            throw new NullPointerException();
        }
        return Long.valueOf(PyBuiltin.str(n));
    }

    public static Double double_(Number n) {
        if (n == null) {
            throw new NullPointerException();
        }
        return Double.valueOf(PyBuiltin.str(n));
    }

    public static Float float_(Number n) {
        if (n == null) {
            throw new NullPointerException();
        }
        return Float.valueOf(PyBuiltin.str(n));
    }

    public static Boolean hasattr(Object o, String fieldName) {
        return PyBuiltin.hasattr(o, fieldName, false);
    }

    public static Boolean hasattr(Object o, String fieldName, boolean onlyPublic) {
        if (o == null || fieldName == null) {
            throw new NullPointerException();
        }
        return PyBuiltin.hasattr(o.getClass(), fieldName, onlyPublic);
    }

    public static Boolean hasattr(Class clazz, String fieldName) {
        return PyBuiltin.hasattr(clazz, fieldName, false);
    }

    public static Boolean hasattr(Class clazz, String fieldName, boolean onlyPublic) {
        if (clazz == null || fieldName == null) {
            throw new NullPointerException();
        }
        while (clazz != Object.class) {
            try {
                if (onlyPublic) {
                    clazz.getField(fieldName);
                } else {
                    clazz.getDeclaredField(fieldName);
                }
                return true;
            }
            catch (NoSuchFieldException e) {
                if (onlyPublic) {
                    return false;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    public static <E extends Comparable> List<E> sorted(List<E> source) {
        return PyBuiltin.sorted(source, true);
    }

    public static <E extends Comparable> List<E> sorted(List<E> source, boolean asc) {
        ArrayList<E> copy = new ArrayList<E>(source);
        Collections.sort(copy);
        if (!asc) {
            Collections.reverse(copy);
        }
        return copy;
    }

    public static <E extends Comparable> Set<E> sorted(Set<E> source) {
        return PyBuiltin.sorted(source, true);
    }

    public static <E extends Comparable> Set<E> sorted(Set<E> source, boolean asc) {
        TreeSet<Object> copy;
        if (asc) {
            copy = new TreeSet<E>(source);
        } else {
            copy = new TreeSet(Comparator.reverseOrder());
            copy.addAll(source);
        }
        return copy;
    }

    public static <K extends Comparable, V> Map<K, V> sorted(Map<K, V> source) {
        return PyBuiltin.sorted(source, true);
    }

    public static <K extends Comparable, V> Map<K, V> sorted(Map<K, V> source, boolean asc) {
        TreeMap<Object, V> copy;
        if (asc) {
            copy = new TreeMap<K, V>(source);
        } else {
            copy = new TreeMap(Comparator.reverseOrder());
            copy.putAll(source);
        }
        return copy;
    }

    public static <E> List<E> reversed(List<E> source) {
        if (source == null) {
            throw new NullPointerException();
        }
        ArrayList<E> copy = new ArrayList<E>(source);
        Collections.reverse(copy);
        return copy;
    }

    public static String reversed(String source) {
        if (source == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder(source);
        return PyBuiltin.str(sb.reverse());
    }

    public static <E> Set<E> frozenset(Collection<E> c) {
        return new FrozenSet<E>(c);
    }

    public static <K, V> Set<K> frozenset(Map<K, V> m) {
        return PyBuiltin.frozenset(m.keySet());
    }

    public static <E> Set<E> frozenset(E[] array) {
        return PyBuiltin.frozenset(Arrays.asList(array));
    }

    public static Set<String> frozenset(String s) {
        return PyBuiltin.frozenset(Arrays.asList(s.split("")));
    }

    private static class FrozenSet<E>
    extends HashSet<E> {
        FrozenSet(Collection<? extends E> initCollection) {
            super(initCollection);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }
    }
}

