/*
 * Decompiled with CFR 0.152.
 */
package sideex;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sideex.ProtocolType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideeXWebServiceClientAPI {
    private String baseURL;
    private String hostname;
    private String caFilePath;
    static final int BUFFER_SIZE = 4096;
    private static final int TIME_OUT = 60000;
    private static final String CHARSET = "utf-8";
    private static final String PREFIX = "--";
    private static final String BOUNDARY = UUID.randomUUID().toString();
    private static final String CONTENT_TYPE = "multipart/form-data";
    private static final String LINE_END = "\r\n";
    private HTTPSHostNameVerifier httpsHostNameVerifier;
    private TrustManager[] trustAllCerts;
    public static final HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    public static final SSLSocketFactory defaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();

    public SideeXWebServiceClientAPI(String baseURL, ProtocolType protocolType) throws MalformedURLException {
        this.baseURL = baseURL.trim();
        if (this.baseURL.charAt(this.baseURL.length() - 1) != '/') {
            this.baseURL = this.baseURL + "/";
        }
        this.hostname = new URL(this.baseURL).getHost();
        if (protocolType == ProtocolType.HTTPS_DISABLE) {
            this.setHTTPSDisable();
        }
    }

    public SideeXWebServiceClientAPI(String baseURL, ProtocolType protocolType, String caFilePath) throws MalformedURLException {
        this(baseURL, protocolType);
        this.caFilePath = caFilePath;
        if (protocolType == ProtocolType.HTTPS_ENABLE) {
            try {
                this.httpsHostNameVerifier = new HTTPSHostNameVerifier(this.hostname);
                this.setCertificate(this.caFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setHTTPSToDefault() {
        HttpsURLConnection.setDefaultHostnameVerifier(defaultHostnameVerifier);
        HttpsURLConnection.setDefaultSSLSocketFactory(defaultSSLSocketFactory);
    }

    public void setHTTPSDisable() {
        this.trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(new NullHostNameVerifier());
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCertificate(String caFile) throws Exception {
        Certificate ca;
        FileInputStream caFileInputStream;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream caInput = caFileInputStream = new FileInputStream(caFile);
        try {
            ca = certificateFactory.generateCertificate(caInput);
        }
        finally {
            ((InputStream)caInput).close();
        }
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                for (X509Certificate cert : chain) {
                    cert.checkValidity();
                    try {
                        cert.verify(((X509Certificate)ca).getPublicKey());
                    }
                    catch (Exception e) {
                        throw new CertificateException(e);
                    }
                }
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }}, null);
        HttpsURLConnection.setDefaultHostnameVerifier(this.httpsHostNameVerifier);
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
    }

    public String echo() {
        HttpURLConnection conn = null;
        URL url = null;
        StringBuilder response = new StringBuilder();
        try {
            url = new URL(this.baseURL + "sideex-webservice/echo");
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            int responseCode = 200;
            responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                br.close();
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runTestSuite(Map<String, File> file) throws IOException {
        URL url = new URL(this.baseURL + "sideex-webservice/runTestSuites");
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setReadTimeout(60000);
        conn.setConnectTimeout(60000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
        DataOutputStream dos = null;
        dos = new DataOutputStream(conn.getOutputStream());
        StringBuilder fileSb = new StringBuilder();
        for (Map.Entry<String, File> fileEntry : file.entrySet()) {
            fileSb.append(PREFIX).append(BOUNDARY).append(LINE_END).append("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileEntry.getKey() + "\"" + LINE_END).append("Content-Transfer-Encoding: 8bit\r\n").append(LINE_END);
            dos.writeBytes(fileSb.toString());
            dos.flush();
            FileInputStream is = null;
            is = new FileInputStream(fileEntry.getValue());
            try {
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    dos.write(buffer, 0, len);
                }
                dos.writeBytes(LINE_END);
            }
            finally {
                if (is == null) continue;
                ((InputStream)is).close();
            }
        }
        dos.writeBytes(PREFIX + BOUNDARY + PREFIX + LINE_END);
        dos.flush();
        dos.close();
        StringBuilder response = new StringBuilder();
        if (conn.getResponseCode() == 200) {
            InputStream in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
        }
        conn.disconnect();
        return response.toString();
    }

    public String getState(String token) throws IOException {
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", token);
        String dataParams = this.getDataString(params);
        URL url = new URL(this.baseURL + "sideex-webservice/getState" + dataParams);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        int responseCode = 200;
        responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            br.close();
        }
        conn.disconnect();
        return response.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(Map<String, String> formData, String filePath, int option) throws IOException {
        String tempBaseURL = this.baseURL;
        tempBaseURL = option == 0 ? tempBaseURL + "sideex-webservice/downloadReports" : tempBaseURL + "sideex-webservice/downloadLogs";
        String dataParams = this.getDataString(formData);
        URL url = new URL(tempBaseURL + dataParams);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setReadTimeout(60000);
        conn.setConnectTimeout(60000);
        int responseCode = conn.getResponseCode();
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        if (responseCode == 200) {
            try {
                inputStream = conn.getInputStream();
                fileOutputStream = new FileOutputStream(filePath);
                int bytesRead = -1;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        } else {
            System.out.println("GET request not worked");
        }
        conn.disconnect();
    }

    public String deleteJob(String token) throws IOException {
        URL url = new URL(this.baseURL + "sideex-webservice/deleteJob");
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setReadTimeout(60000);
        conn.setConnectTimeout(60000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
        HashMap<String, String> strParams = new HashMap<String, String>();
        strParams.put("token", token);
        DataOutputStream dos = null;
        StringBuilder response = new StringBuilder();
        dos = new DataOutputStream(conn.getOutputStream());
        dos.writeBytes(SideeXWebServiceClientAPI.getStrParams(strParams).toString());
        dos.writeBytes(PREFIX + BOUNDARY + PREFIX + LINE_END);
        dos.flush();
        dos.close();
        if (conn.getResponseCode() == 200) {
            InputStream in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
        }
        conn.disconnect();
        return response.toString();
    }

    private String getDataString(Map<String, String> params) throws IOException {
        String UTF_8 = "UTF-8";
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (isFirst) {
                isFirst = false;
                result.append("?");
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }

    private static StringBuilder getStrParams(Map<String, String> strParams) {
        StringBuilder strSb = new StringBuilder();
        for (Map.Entry<String, String> entry : strParams.entrySet()) {
            strSb.append(PREFIX).append(BOUNDARY).append(LINE_END).append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINE_END).append("Content-Type: text/plain; charset=utf-8\r\n").append("Content-Transfer-Encoding: 8bit\r\n").append(LINE_END).append(entry.getValue()).append(LINE_END);
        }
        return strSb;
    }

    private static class NullHostNameVerifier
    implements HostnameVerifier {
        private NullHostNameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class HTTPSHostNameVerifier
    implements HostnameVerifier {
        private String hostname;

        public HTTPSHostNameVerifier(String hostname) {
            this.hostname = hostname;
        }

        public boolean verify(String hostname, SSLSession session) {
            if (this.hostname.equals(hostname)) {
                return true;
            }
            HostnameVerifier hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            return hostnameVerifier.verify(hostname, session);
        }
    }
}

