package com.happyfox.widget;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.webkit.JavascriptInterface;

/**
 * Created by Sureshkumar on 06/09/17.
 */

public class HFCWidget {

    static HFCWidget singletonInstance = null;
    static String mEmbedToken = "";
    static String mAccessToken = "";
    Context mContext;

    private HFCWidget(Context context) {
        this.mContext = context;
    }

    public static HFCWidget create(Context context, String embedToken, String accessToken) throws WidgetException {
        getWidgetInstance(context);
        setEmbedToken(embedToken);
        setAccessToken(accessToken);
        return singletonInstance;
    }

    public static HFCWidget getWidgetInstance(Context context) {
        if (singletonInstance == null) {
            synchronized (HFCWidget.class) {
                if (singletonInstance == null) {
                    singletonInstance = new HFCWidget(context.getApplicationContext());
                }
            }
        }
        return singletonInstance;
    }

    public void show(Activity activity) {
        activity.startActivity(new Intent("com.happyfox.widget.ShowHelp"));
    }

    @JavascriptInterface
    public String getEmbedToken() {
        return mEmbedToken;
    }

    private static void setEmbedToken(String token) throws WidgetException {
        if (token != null && !token.trim().isEmpty())
            mEmbedToken = token;
        else
            throw new WidgetException("EmbedToken not found");
    }

    @JavascriptInterface
    public String getAccessToken() {
        return mAccessToken;
    }

    private static void setAccessToken(String token) throws WidgetException {
        if (token != null && !token.trim().isEmpty())
            mAccessToken = token;
        else
            throw new WidgetException("AccessToken not found");
    }
}