/*
 * Decompiled with CFR 0.152.
 */
package ru.shmakinv.android.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.devspark.robototextview.util.RobotoTypefaceUtils;
import com.devspark.robototextview.widget.RobotoTextView;
import ru.shmakinv.android.widget.R;

public class PriceView
extends LinearLayout {
    private RobotoTextView mPriceView;
    private RobotoTextView mPriceViewLimiter;
    private RobotoTextView mRoubleView;
    private String mValue;
    private float mTextSize;
    private int mRoublePadding;
    private int mMaxLength;
    private int mTextColor;

    public PriceView(Context context) {
        super(context);
        this.init(context, null);
    }

    public PriceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public PriceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public PriceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        PriceView.inflate((Context)context, (int)R.layout.layout_price_view, (ViewGroup)this);
        this.mPriceView = (RobotoTextView)this.findViewById(R.id.price);
        this.mPriceViewLimiter = (RobotoTextView)this.findViewById(R.id.price_limiter);
        this.mRoubleView = (RobotoTextView)this.findViewById(R.id.currency_sign);
        if (!this.isInEditMode()) {
            RobotoTypefaceUtils.initView((TextView)this.mPriceView, (Context)context, (AttributeSet)attrs);
            RobotoTypefaceUtils.initView((TextView)this.mPriceViewLimiter, (Context)context, (AttributeSet)attrs);
            RobotoTypefaceUtils.initView((TextView)this.mRoubleView, (Context)context, (AttributeSet)attrs);
        }
        this.initResources(context, attrs);
    }

    private void initResources(@NonNull Context context, @NonNull AttributeSet attrs) {
        int[] attributes = new int[]{16842931};
        TypedArray sysAttr = context.obtainStyledAttributes(attrs, attributes);
        TypedArray customAttrs = context.obtainStyledAttributes(attrs, R.styleable.PriceView);
        Resources res = this.getResources();
        int defPadding = 0;
        int defLength = 0;
        int defColor = 0;
        float defTextSize = 0.0f;
        if (res != null) {
            defPadding = (int)res.getDimension(R.dimen.default_padding);
            defLength = res.getInteger(R.integer.default_max_length);
            defColor = ContextCompat.getColor((Context)context, (int)17170444);
            defTextSize = res.getDimension(R.dimen.default_font_size);
        }
        if (sysAttr != null) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mPriceView.getLayoutParams();
            params.gravity = sysAttr.getInteger(0, 17);
            this.mPriceView.setLayoutParams((ViewGroup.LayoutParams)params);
            sysAttr.recycle();
        }
        if (customAttrs != null) {
            this.mRoublePadding = (int)customAttrs.getDimension(R.styleable.PriceView_roublePadding, (float)defPadding);
            this.mValue = customAttrs.getString(R.styleable.PriceView_value);
            this.mTextSize = customAttrs.getDimension(R.styleable.PriceView_textSize, defTextSize);
            this.mTextColor = customAttrs.getColor(R.styleable.PriceView_textColor, defColor);
            this.mMaxLength = customAttrs.getInteger(R.styleable.PriceView_regionLength, defLength);
            this.setValue(this.mValue);
            this.setTextSize(this.mTextSize);
            this.setTextColor(this.mTextColor);
            this.setRegionLength(this.mMaxLength);
            this.setRoublePadding(this.mRoublePadding);
            customAttrs.recycle();
        }
    }

    public void setTextSize(float size) {
        this.mTextSize = size;
        this.mPriceView.setTextSize(0, size);
        this.mPriceViewLimiter.setTextSize(0, size);
        this.mRoubleView.setTextSize(0, size);
    }

    public void setRegionLength(int signCount) {
        this.mMaxLength = signCount;
        this.mPriceViewLimiter.setText((CharSequence)this.updateLimit(signCount));
    }

    @NonNull
    private String updateLimit(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("8");
        }
        return sb.toString();
    }

    public void setRoublePadding(int padding) {
        this.mRoublePadding = padding;
        this.mRoubleView.setPadding(padding, 0, 0, 0);
    }

    public void setTypeface(@NonNull Typeface typeface) {
        RobotoTypefaceUtils.setUp((TextView)this.mPriceView, (Typeface)typeface);
        RobotoTypefaceUtils.setUp((TextView)this.mRoubleView, (Typeface)typeface);
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.mPriceView.setTextColor(textColor);
        this.mRoubleView.setTextColor(textColor);
    }

    public void setValue(@NonNull String value) {
        this.mValue = value;
        this.mPriceView.setText((CharSequence)value);
    }

    @Nullable
    public String getValue() {
        return this.mValue;
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public int getRoublePadding() {
        return this.mRoublePadding;
    }

    public int getMaxLength() {
        return this.mMaxLength;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.value = this.mValue;
        ss.textSize = this.mTextSize;
        ss.roublePadding = this.mRoublePadding;
        ss.maxTextLength = this.mMaxLength;
        ss.color = this.mTextColor;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setValue(ss.value);
        this.setTextSize(ss.textSize);
        this.setRoublePadding(ss.roublePadding);
        this.setRegionLength(ss.maxTextLength);
        this.setTextColor(ss.color);
    }

    static class SavedState
    extends View.BaseSavedState {
        String value;
        float textSize;
        int roublePadding;
        int maxTextLength;
        int color;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.value = in.readString();
            this.textSize = in.readFloat();
            this.roublePadding = in.readInt();
            this.maxTextLength = in.readInt();
            this.color = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.value);
            out.writeFloat(this.textSize);
            out.writeInt(this.roublePadding);
            out.writeInt(this.maxTextLength);
            out.writeInt(this.color);
        }
    }
}

