/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangji92.mybatis.reload.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.xml.sax.EntityResolver;

public class MybatisMapperXmlFileReloadService {
    private static final Logger log = LoggerFactory.getLogger(MybatisMapperXmlFileReloadService.class);
    private List<SqlSessionFactory> sqlSessionFactoryList;

    public MybatisMapperXmlFileReloadService(List<SqlSessionFactory> sqlSessionFactoryList) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
    }

    public boolean reloadAllSqlSessionFactoryMapper(String mapperFilePath) {
        if (CollectionUtils.isEmpty(this.sqlSessionFactoryList)) {
            log.warn("not find SqlSessionFactory bean");
            return false;
        }
        Path path = Paths.get(mapperFilePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            log.warn("mybatis reload mapper xml not exist ={}", (Object)mapperFilePath);
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(true);
        this.sqlSessionFactoryList.parallelStream().forEach(sqlSessionFactory -> {
            Configuration configuration = sqlSessionFactory.getConfiguration();
            if (!this.removeMapperCacheAndReloadNewMapperFile(path, configuration)) {
                log.warn("reload new mapper file fail path={}", (Object)path.toString());
                result.set(false);
            } else {
                log.info("reload new mapper file success path={}", (Object)path.toString());
            }
        });
        return result.get();
    }

    private Object readField(Object target, String name) {
        Field field = ReflectionUtils.findField(target.getClass(), (String)name);
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)target);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeMapperCacheAndReloadNewMapperFile(Path watchPath, Configuration configuration) {
        try (InputStream fileInputStream = Files.newInputStream(watchPath, new OpenOption[0]);){
            XPathParser context = new XPathParser(fileInputStream, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver());
            XNode contextNode = context.evalNode("/mapper");
            if (null == contextNode) {
                boolean bl2 = false;
                return bl2;
            }
            String namespace = contextNode.getStringAttribute("namespace");
            if (namespace == null) throw new BuilderException("Mapper's namespace cannot be empty");
            if (namespace.isEmpty()) {
                throw new BuilderException("Mapper's namespace cannot be empty");
            }
            this.removeOldMapperFileConfigCache(configuration, contextNode, namespace);
            this.addNewMapperFile(configuration, watchPath, namespace);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.warn("load fail {}", (Object)watchPath.toString(), (Object)e);
            return false;
        }
    }

    private void removeOldMapperFileConfigCache(Configuration configuration, XNode mapper, String namespace) {
        String xmlResource = namespace.replace('.', '/') + ".xml";
        ((Set)this.readField(configuration, "loadedResources")).remove(xmlResource);
        for (XNode node : mapper.evalNodes("parameterMap")) {
            String parameterMapId = this.resolveId(namespace, node.getStringAttribute("id"));
            ((Map)this.readField(configuration, "parameterMaps")).remove(parameterMapId);
        }
        for (XNode node : mapper.evalNodes("resultMap")) {
            String resultMapId = this.resolveId(namespace, node.getStringAttribute("id"));
            ((Map)this.readField(configuration, "resultMaps")).remove(resultMapId);
        }
        for (XNode node : mapper.evalNodes("sql")) {
            String sqlId = this.resolveId(namespace, node.getStringAttribute("id"));
            ((Map)this.readField(configuration, "sqlFragments")).remove(sqlId);
        }
        for (XNode node : mapper.evalNodes("select|insert|update|delete")) {
            String statementId = this.resolveId(namespace, node.getStringAttribute("id"));
            ((Map)this.readField(configuration, "mappedStatements")).remove(statementId);
        }
    }

    private void addNewMapperFile(Configuration configuration, Path watchPath, String namespace) throws IOException {
        try (InputStream fileInputStream = Files.newInputStream(watchPath, new OpenOption[0]);){
            String xmlResource = namespace.replace('.', '/') + ".xml";
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(fileInputStream, configuration, xmlResource, configuration.getSqlFragments());
            xmlMapperBuilder.parse();
        }
    }

    private String resolveId(String namespace, String id) {
        return namespace + "." + id;
    }
}

