/*
 * Decompiled with CFR 0.152.
 */
package com.github.wangji92.mybatis.reload.core;

import com.github.wangji92.mybatis.reload.core.MybatisMapperXmlFileReloadService;
import io.methvin.watcher.DirectoryChangeEvent;
import io.methvin.watcher.DirectoryWatcher;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.ResourceUtils;

public class MybatisMapperXmlFileWatchService
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MybatisMapperXmlFileWatchService.class);
    private String mybatisMapperFileLocationPattern;
    private AtomicInteger reloadCount = new AtomicInteger(0);
    private static String XML_PATTERN = "*.xml";
    private MybatisMapperXmlFileReloadService mybatisMapperXmlFileReloadService;
    private DirectoryWatcher watcher;
    private Resource[] mapperLocations;

    public MybatisMapperXmlFileWatchService(String mybatisMapperFileLocationPattern) {
        this.mybatisMapperFileLocationPattern = mybatisMapperFileLocationPattern;
    }

    public void initWatchService() {
        log.info("init mybatis mapper reload service begin");
        if (this.watcher != null) {
            return;
        }
        this.scanMapperXml();
        Set<Path> mapperXmlFileDirPaths = this.getWatchMapperXmlFileDirPaths();
        if (CollectionUtils.isEmpty(mapperXmlFileDirPaths)) {
            log.warn("not found mapper xml in {}", (Object)this.mybatisMapperFileLocationPattern);
            return;
        }
        this.startMapperWatchService(mapperXmlFileDirPaths);
        log.info("init mybatis mapper reload service success");
    }

    private void startMapperWatchService(Set<Path> mapperXmlFileDirPaths) {
        try {
            this.watcher = DirectoryWatcher.builder().paths(new ArrayList<Path>(mapperXmlFileDirPaths)).listener(event -> {
                if (DirectoryChangeEvent.EventType.MODIFY.equals((Object)event.eventType())) {
                    if (event.isDirectory()) {
                        return;
                    }
                    Path path = event.path();
                    String fullPath = path.toString();
                    if (!PatternMatchUtils.simpleMatch((String)XML_PATTERN, (String)fullPath)) {
                        return;
                    }
                    boolean result = this.mybatisMapperXmlFileReloadService.reloadAllSqlSessionFactoryMapper(fullPath);
                    log.info("reload all count ={} current result={} mapper path={} ", new Object[]{path, this.reloadCount.incrementAndGet(), result});
                }
            }).fileHashing(true).build();
            Thread watchThread = new Thread(this::runWatchService, "WatchService mybatis mapper xml reload");
            watchThread.setDaemon(true);
            watchThread.start();
        }
        catch (Exception e) {
            log.error("startMapperWatchService error", (Throwable)e);
        }
    }

    private Set<Path> getWatchMapperXmlFileDirPaths() {
        Resource[] resources = this.mapperLocations;
        if (resources.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Path> parentDirSet = new HashSet<Path>(5);
        for (Resource resource : resources) {
            try {
                if (!resource.exists() || ResourceUtils.isJarURL((URL)resource.getURL()) || !ResourceUtils.isFileURL((URL)resource.getURL())) continue;
                File file = resource.getFile();
                String parentDir = file.getParent();
                parentDirSet.add(Paths.get(parentDir, new String[0]));
            }
            catch (Exception e) {
                log.warn("getWatchMapperXmlFileDirPaths error resource={}", (Object)resource, (Object)e);
            }
        }
        return parentDirSet;
    }

    private void scanMapperXml() {
        try {
            this.mapperLocations = new PathMatchingResourcePatternResolver().getResources(this.mybatisMapperFileLocationPattern);
        }
        catch (IOException e) {
            log.error("scanMapperXml error", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        try {
            this.watcher.close();
        }
        catch (Exception e) {
            log.debug("DirectoryWatcher got an exception while close!", (Throwable)e);
        }
    }

    public void setMybatisMapperXmlFileReloadService(MybatisMapperXmlFileReloadService mybatisMapperXmlFileReloadService) {
        this.mybatisMapperXmlFileReloadService = mybatisMapperXmlFileReloadService;
    }

    private void runWatchService() {
        try {
            if (this.watcher != null) {
                this.watcher.watch();
            }
        }
        catch (Exception e) {
            log.debug("DirectoryWatcher got an exception while watching!", (Throwable)e);
        }
    }
}

