/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.spring.boot.autoconfigure;

import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class MybatisSqlCompletePrintInterceptor
implements Interceptor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(MybatisSqlCompletePrintInterceptor.class);
    private Configuration configuration = null;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
    };

    public MybatisSqlCompletePrintInterceptor(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        long startTime = System.currentTimeMillis();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            String sql = this.getSql(target);
            long endTime = System.currentTimeMillis();
            long sqlCost = endTime - startTime;
            log.info("SQL:{}    cost={}", (Object)sql, (Object)sqlCost);
        }
    }

    private String getSql(Object target) {
        try {
            StatementHandler statementHandler = (StatementHandler)target;
            BoundSql boundSql = statementHandler.getBoundSql();
            return this.formatSql(boundSql, this.configuration);
        }
        catch (Exception e) {
            log.warn("get sql error {}", target, (Object)e);
            return "";
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private String formatSql(BoundSql boundSql, Configuration configuration) {
        String sql = boundSql.getSql();
        List parameterMappings = boundSql.getParameterMappings();
        Object parameterObject = boundSql.getParameterObject();
        if (sql == null || sql.length() == 0) {
            return "";
        }
        if (configuration == null) {
            return "";
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        sql = this.beautifySql(sql);
        if (parameterMappings != null) {
            for (ParameterMapping parameterMapping : parameterMappings) {
                Object value;
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                String paramValueStr = "";
                paramValueStr = value instanceof String ? "'" + value + "'" : (value instanceof Date ? "'" + DATE_FORMAT_THREAD_LOCAL.get().format(value) + "'" : value + "");
                if (!propertyName.contains("frch_criterion") && !propertyName.contains("ew.paramNameValuePairs")) {
                    paramValueStr = "/*" + propertyName + "*/" + paramValueStr;
                }
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(paramValueStr));
            }
        }
        return sql;
    }

    private String beautifySql(String sql) {
        sql = sql.replaceAll("[\\s\n ]+", " ");
        return sql;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

