/*
 * Decompiled with CFR 0.152.
 */
package com.mybatis.spring.boot.autoconfigure;

import com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration;
import com.mybatis.spring.boot.autoconfigure.MybatisSqlCompletePrintInterceptor;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.apache.ibatis.session.SqlSessionFactory"})
@ConditionalOnExpression(value="${mybatis.print:true}")
public class MybatisSqlPrintAutoConfiguration {
    @Autowired
    private List<SqlSessionFactory> sqlSessionFactoryList;

    @Configuration
    @ConditionalOnClass(value={PageHelperAutoConfiguration.class})
    @AutoConfigureAfter(value={PageHelperAutoConfiguration.class})
    public class AutoConfigPrintInterceptor {
        @PostConstruct
        public void addPrintInterceptor() {
            for (SqlSessionFactory sqlSessionFactory : MybatisSqlPrintAutoConfiguration.this.sqlSessionFactoryList) {
                org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
                MybatisSqlCompletePrintInterceptor printInterceptor = new MybatisSqlCompletePrintInterceptor(configuration);
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)printInterceptor);
            }
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration"})
    public class SupportPageHelper {
        @PostConstruct
        public void addPrintInterceptor() {
            for (SqlSessionFactory sqlSessionFactory : MybatisSqlPrintAutoConfiguration.this.sqlSessionFactoryList) {
                org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
                MybatisSqlCompletePrintInterceptor printInterceptor = new MybatisSqlCompletePrintInterceptor(configuration);
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)printInterceptor);
            }
        }
    }
}

