/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.webdav;

import com.github.alanger.webdav.Text;
import com.github.alanger.webdav.VfsDavResource;
import com.github.alanger.webdav.VfsDavResourceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceIteratorImpl;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.SupportedLock;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsDavResource
implements DavResource {
    private static final Logger log = LoggerFactory.getLogger(VfsDavResource.class);
    public static final String METHODS = "OPTIONS, GET, HEAD, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK";
    public static final String COMPLIANCE_CLASSES = DavCompliance.concatComplianceClasses((String[])new String[]{"1", "2", "3"});
    public static final String UTF_8 = "UTF-8";
    private DavResourceFactory factory;
    private LockManager lockManager;
    private DavSession session;
    private DavResourceLocator locator;
    private FileObject fileObject = null;
    protected DavPropertySet properties;
    protected boolean propsInitialized = false;
    private boolean isCollection = false;
    private long modificationTime = -1L;
    private long contentLength = -1L;

    public VfsDavResource(DavResourceLocator locator, DavResourceFactory factory, DavSession session, boolean isCollection) throws DavException {
        this(locator, factory, session, null);
        this.isCollection = isCollection;
    }

    public VfsDavResource(DavResourceLocator locator, DavResourceFactory factory, DavSession session, FileObject fileObject) throws DavException {
        if (locator == null || session == null) {
            throw new IllegalArgumentException("Locator or session is null");
        }
        this.session = session;
        this.factory = factory;
        this.locator = locator;
        if (locator.getResourcePath() != null) {
            if (fileObject != null) {
                this.fileObject = fileObject;
                this.properties = new DavPropertySet();
                try {
                    this.isCollection = fileObject.isFolder();
                }
                catch (FileSystemException e) {
                    this.fileObject = null;
                    String msg = "Failed to check if it is a folder at '" + this.getResourcePath() + "'";
                    log.debug(msg, (Throwable)e);
                    throw new DavException(404);
                }
            }
        } else {
            throw new DavException(404);
        }
    }

    public String getComplianceClass() {
        return COMPLIANCE_CLASSES;
    }

    public String getSupportedMethods() {
        return METHODS;
    }

    public boolean exists() {
        return this.fileObject != null;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public String getDisplayName() {
        String resPath = this.getResourcePath();
        return resPath != null ? Text.getName((String)resPath) : resPath;
    }

    public DavResourceLocator getLocator() {
        return this.locator;
    }

    public String getResourcePath() {
        return this.locator.getResourcePath();
    }

    public String getHref() {
        return this.locator.getHref(this.isCollection());
    }

    public long getModificationTime() {
        this.initProperties();
        return this.modificationTime;
    }

    public long getContentLength() {
        this.initProperties();
        return this.contentLength;
    }

    public void spool(OutputContext outputContext) throws IOException {
        if (this.exists() && !this.isCollection() && outputContext != null) {
            outputContext.setContentLength(this.getContentLength());
            try (InputStream is = this.fileObject.getContent().getInputStream();
                 OutputStream os = outputContext.getOutputStream();){
                if (os != null) {
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
            }
        }
    }

    public DavProperty<?> getProperty(DavPropertyName name) {
        this.initProperties();
        return this.properties.get(name);
    }

    public DavPropertySet getProperties() {
        this.initProperties();
        return this.properties;
    }

    public DavPropertyName[] getPropertyNames() {
        return this.getProperties().getPropertyNames();
    }

    protected void initProperties() {
        if (!this.exists() || this.propsInitialized) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("# initProperties: {}, exist: {}, isCollection: {}", new Object[]{this.getResourcePath(), this.exists(), this.isCollection()});
        }
        PropertyExportCtx context = new PropertyExportCtx(this, null);
        String mimeType = "application/octet-stream";
        if (this.exists()) {
            try (FileContent content = this.fileObject.getContent();){
                if (!this.isCollection()) {
                    this.contentLength = content.getSize();
                    mimeType = content.getContentInfo().getContentType();
                } else {
                    mimeType = "inode/directory";
                }
                this.modificationTime = content.getLastModifiedTime();
            }
            catch (FileSystemException e) {
                String msg = "Failed while initialize properties at '" + this.getResourcePath() + "'";
                log.debug(msg, (Throwable)e);
            }
        }
        context.setModificationTime(this.modificationTime);
        context.setCreationTime(this.modificationTime);
        context.setContentLength(this.contentLength);
        context.setContentType(mimeType, null);
        if (this.contentLength > -1L && this.modificationTime > -1L) {
            String etag = "\"" + this.contentLength + "-" + this.modificationTime + "\"";
            context.setETag(etag);
        }
        if (this.getDisplayName() != null) {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        }
        if (this.isCollection()) {
            this.properties.add((DavProperty)new ResourceType(1));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        } else {
            this.properties.add((DavProperty)new ResourceType(0));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
        this.properties.add((DavProperty)new LockDiscovery(this.getLock(Type.WRITE, Scope.EXCLUSIVE)));
        SupportedLock supportedLock = new SupportedLock();
        supportedLock.addEntry(Type.WRITE, Scope.EXCLUSIVE);
        this.properties.add((DavProperty)supportedLock);
        this.propsInitialized = true;
    }

    public void setProperty(DavProperty<?> property) throws DavException {
        throw new DavException(501);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        throw new DavException(501);
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        if (log.isTraceEnabled()) {
            log.trace("# alterProperties: {}, exist: {}, isCollection: {}", new Object[]{this.getResourcePath(), this.exists(), this.isCollection()});
        }
        if (this.isLocked((DavResource)this)) {
            throw new DavException(423);
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse msr = new MultiStatusResponse(this.getHref(), null);
        HashMap failures = new HashMap();
        for (PropEntry propEntry : changeList) {
            int statusCode;
            if (failures.containsKey(propEntry)) {
                Object error = failures.get(propEntry);
                statusCode = error instanceof DavException ? ((DavException)error).getErrorCode() : 500;
            } else {
                int n = statusCode = failures.isEmpty() ? 200 : 424;
            }
            if (propEntry instanceof DavProperty) {
                msr.add(((DavProperty)propEntry).getName(), statusCode);
                continue;
            }
            msr.add((DavPropertyName)propEntry, statusCode);
        }
        return msr;
    }

    public DavResource getCollection() {
        if (log.isTraceEnabled()) {
            log.trace("# getCollection: {}, exist: {}, isCollection: {}", new Object[]{this.getResourcePath(), this.exists(), this.isCollection()});
        }
        DavResource parent = null;
        if (this.getResourcePath() != null && !this.getResourcePath().equals("/")) {
            String parentPath = Text.getRelativeParent((String)this.getResourcePath(), (int)1);
            if (parentPath.equals("")) {
                parentPath = "/";
            }
            DavResourceLocator parentloc = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), parentPath);
            try {
                parent = this.factory.createResource(parentloc, this.session);
            }
            catch (DavException e) {
                log.debug("getCollection error", (Throwable)e);
            }
        }
        return parent;
    }

    public DavResourceIterator getMembers() {
        if (log.isTraceEnabled()) {
            log.trace("# getMembers: {}, exist: {}, isCollection: {}", new Object[]{this.getResourcePath(), this.exists(), this.isCollection()});
        }
        ArrayList<DavResource> list = new ArrayList<DavResource>();
        if (this.exists() && this.isCollection()) {
            try {
                FileObject[] children;
                String parentPath = this.getResourcePath();
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                for (FileObject n : children = this.fileObject.getChildren()) {
                    String path = parentPath + n.getName().getBaseName();
                    DavResourceLocator resourceLocator = this.locator.getFactory().createResourceLocator(this.locator.getPrefix(), this.locator.getWorkspacePath(), path, false);
                    DavResource childRes = this.factory.createResource(resourceLocator, this.session);
                    if (childRes == null || !childRes.exists()) continue;
                    list.add(childRes);
                }
            }
            catch (FileSystemException e) {
                log.debug("getMembers FS error", (Throwable)e);
            }
            catch (DavException e) {
                log.debug("getMembers Dav error", (Throwable)e);
            }
        }
        return new DavResourceIteratorImpl(list);
    }

    public void addMember(DavResource member, InputContext inputContext) throws DavException {
        block31: {
            if (log.isTraceEnabled()) {
                log.trace("# addMember: {}", (Object)member.getResourcePath());
            }
            if (!this.exists()) {
                throw new DavException(409);
            }
            if (this.isLocked((DavResource)this) || this.isLocked(member)) {
                throw new DavException(423);
            }
            try {
                String memberName = Text.getName((String)member.getLocator().getRepositoryPath());
                FileObject child = this.fileObject.resolveFile(memberName);
                if (member.isCollection()) {
                    child.createFolder();
                    break block31;
                }
                child.createFile();
                try (InputStream is = inputContext.getInputStream();
                     OutputStream os = child.getContent().getOutputStream();){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                log.error("Error while importing resource: " + e.toString());
                throw new DavException(500, e.getMessage());
            }
        }
    }

    public void removeMember(DavResource member) throws DavException {
        if (log.isTraceEnabled()) {
            log.trace("# removeMember: {}", (Object)member.getResourcePath());
        }
        if (!this.exists() || !member.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked((DavResource)this) || this.isLocked(member)) {
            throw new DavException(423);
        }
        try {
            String memberName = Text.getName((String)member.getLocator().getRepositoryPath());
            FileObject child = this.fileObject.getChild(memberName);
            child.deleteAll();
        }
        catch (IOException e) {
            log.error("Error while remove member: " + e.toString());
            throw new DavException(500, e.getMessage());
        }
        try {
            ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
            if (lock != null) {
                this.lockManager.releaseLock(lock.getToken(), member);
            }
        }
        catch (DavException davException) {
            // empty catch block
        }
    }

    public void move(DavResource destination) throws DavException {
        if (log.isTraceEnabled()) {
            log.trace("# move: {} - {} to {} - {}", new Object[]{this.getResourcePath(), this.exists(), destination.getResourcePath(), destination.exists()});
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked((DavResource)this)) {
            throw new DavException(423);
        }
        this.checkSameWorkspace(destination.getLocator());
        try {
            FileObject destRootObject = ((VfsDavResourceFactory)destination.getFactory()).getRootObject();
            FileObject destFile = destRootObject.resolveFile(destination.getLocator().getRepositoryPath());
            this.fileObject.moveTo(destFile);
        }
        catch (IOException e) {
            log.error("Error while move resource: " + e.toString());
            throw new DavException(500, e.getMessage());
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (log.isTraceEnabled()) {
            log.trace("# copy: {} - {} to {} - {}", new Object[]{this.getResourcePath(), this.exists(), destination.getResourcePath(), destination.exists()});
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (this.isLocked(destination)) {
            throw new DavException(423);
        }
        this.checkSameWorkspace(destination.getLocator());
        try {
            FileObject destRootObject = ((VfsDavResourceFactory)destination.getFactory()).getRootObject();
            FileObject destFile = destRootObject.resolveFile(destination.getLocator().getRepositoryPath());
            destFile.copyFrom(this.fileObject, (FileSelector)new AllFileSelector());
        }
        catch (IOException e) {
            log.error("Error while copy resource: " + e.toString());
            throw new DavException(500, e.getMessage());
        }
    }

    private void checkSameWorkspace(DavResourceLocator otherLoc) throws DavException {
        String wspname = this.getLocator().getWorkspaceName();
        if (!wspname.equals(otherLoc.getWorkspaceName())) {
            throw new DavException(403, "Workspace mismatch: expected '" + wspname + "'; found: '" + otherLoc.getWorkspaceName() + "'");
        }
    }

    private boolean isLocked(DavResource res) {
        ActiveLock lock = res.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            return false;
        }
        for (String sLockToken : this.session.getLockTokens()) {
            if (!sLockToken.equals(lock.getToken())) continue;
            return false;
        }
        return true;
    }

    public boolean isLockable(Type type, Scope scope) {
        return Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope);
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.getLock(type, scope) != null;
    }

    public ActiveLock getLock(Type type, Scope scope) {
        ActiveLock lock = null;
        if (this.exists() && Type.WRITE.equals((Object)type) && Scope.EXCLUSIVE.equals((Object)scope)) {
            lock = this.lockManager.getLock(type, scope, (DavResource)this);
        }
        return lock;
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        ActiveLock lock = null;
        if (!this.isLockable(lockInfo.getType(), lockInfo.getScope())) {
            throw new DavException(412, "Unsupported lock type or scope.");
        }
        lock = this.lockManager.createLock(lockInfo, (DavResource)this);
        return lock;
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        ActiveLock lock = this.getLock(lockInfo.getType(), lockInfo.getScope());
        if (lock == null) {
            throw new DavException(412, "No lock with the given type/scope present on resource " + this.getResourcePath());
        }
        lock = this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
        return lock;
    }

    public void unlock(String lockToken) throws DavException {
        ActiveLock lock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (lock == null) {
            throw new DavException(412);
        }
        if (!lock.isLockedByToken(lockToken)) {
            throw new DavException(423);
        }
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockMgr) {
        this.lockManager = lockMgr;
    }

    public DavResourceFactory getFactory() {
        return this.factory;
    }

    public DavSession getSession() {
        return this.session;
    }

    static /* synthetic */ long access$102(VfsDavResource x0, long x1) {
        x0.modificationTime = x1;
        return x0.modificationTime;
    }

    static /* synthetic */ long access$100(VfsDavResource x0) {
        return x0.modificationTime;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

