/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.webdav;

import com.github.alanger.webdav.VfsDavResource;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsDavResourceFactory
implements DavResourceFactory {
    private static Logger log = LoggerFactory.getLogger(VfsDavResourceFactory.class);
    private final LockManager lockMgr;
    private final FileObject root;

    public FileObject getRootObject() {
        return this.root;
    }

    public VfsDavResourceFactory(LockManager lockMgr, FileObject root) {
        this.lockMgr = lockMgr;
        this.root = root;
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        DavResource resource;
        try {
            DavSession session = request.getDavSession();
            FileObject fobj = this.root.resolveFile(locator.getRepositoryPath());
            if (log.isTraceEnabled()) {
                log.trace("# createResource by request: {}, exist: {}", (Object)locator.getRepositoryPath(), (Object)fobj.exists());
            }
            resource = this.createResource(locator, session, request, fobj);
            resource.addLockManager(this.lockMgr);
        }
        catch (FileSystemException e) {
            log.debug("createResource by request error ", (Throwable)e);
            throw new DavException(500, (Throwable)e);
        }
        return resource;
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        DavResource resource;
        try {
            FileObject fobj = this.root.resolveFile(locator.getRepositoryPath());
            if (log.isTraceEnabled()) {
                log.trace("# createResource by session: {}, exist: {}", (Object)locator.getRepositoryPath(), (Object)fobj.exists());
            }
            resource = this.createResource(locator, session, null, fobj);
            resource.addLockManager(this.lockMgr);
        }
        catch (FileSystemException e) {
            log.debug("createResource by session error ", (Throwable)e);
            throw new DavException(500, (Throwable)e);
        }
        return resource;
    }

    protected DavResource createResource(DavResourceLocator locator, DavSession session, DavServletRequest request, FileObject fobj) throws DavException, FileSystemException {
        if (!fobj.exists()) {
            boolean isCollection = request != null ? DavMethods.isCreateCollectionRequest((DavServletRequest)request) : false;
            return new VfsDavResource(locator, (DavResourceFactory)this, session, isCollection);
        }
        return new VfsDavResource(locator, (DavResourceFactory)this, session, fobj);
    }
}

