/*
 * Decompiled with CFR 0.152.
 */
package com.github.alanger.webdav;

import com.github.alanger.webdav.Text;
import com.github.alanger.webdav.VfsDavLocatorFactory;
import com.github.alanger.webdav.VfsDavResourceFactory;
import com.github.alanger.webdav.VfsDavSessionProvider;
import com.github.alanger.webdav.VfsWebDavServlet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.zip.ZipFileSystemConfigBuilder;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.WebdavResponse;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.server.AbstractWebdavServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VfsWebDavServlet
extends AbstractWebdavServlet {
    private static final long serialVersionUID = 1L;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private LockManager lockManager;
    private DavResourceFactory resourceFactory;
    private DavLocatorFactory locatorFactory;
    private DavSessionProvider davSessionProvider;
    private UserAuthenticator userAuthenticator;
    private FileSystemOptions fileSystemOptions;
    private FilesCache filesCache;
    private CacheStrategy cacheStrategy;
    private FileSystemManager fileSystemManager;
    public static final String VERSION = VfsWebDavServlet.class.getPackage().getImplementationVersion() != null ? VfsWebDavServlet.class.getPackage().getImplementationVersion() : "unknown";
    public static final String INIT_PARAM_ROOTPATH = "rootpath";
    public static final String INIT_PARAM_DOMAIN = "domain";
    public static final String INIT_PARAM_LOGIN = "login";
    public static final String INIT_PARAM_PASSWORD = "password";
    public static final String INIT_PARAM_LISTINGS = "listings-directory";
    public static final String INIT_PARAM_INCTXPATH = "include-context-path";
    public static final String INIT_PARAM_FILESCACHE = "files-cache";
    public static final String INIT_PARAM_CACHESTRATEGY = "cache-strategy";
    public static final String INIT_PARAM_BUILDER = "builder";
    public static final String INIT_PARAM_LOGGER = "logger-name";
    public static final String INIT_PARAM_AUDMETHODS = "audit-methods";
    private FileObject root;
    private String rootpath;
    private boolean listingsDirectory = true;
    private boolean includeContextPath = true;
    private List<String> auditMethods = null;
    private static final DateFormat shortDF = DateFormat.getDateTimeInstance(3, 2);
    private static final String CSS;

    protected boolean isPreconditionValid(WebdavRequest request, DavResource resource) {
        return resource != null && (!resource.exists() || request.matchesIfHeader(resource));
    }

    public synchronized DavSessionProvider getDavSessionProvider() {
        if (this.davSessionProvider == null) {
            this.davSessionProvider = new VfsDavSessionProvider();
        }
        return this.davSessionProvider;
    }

    public void setDavSessionProvider(DavSessionProvider davSessionProvider) {
        this.davSessionProvider = davSessionProvider;
    }

    public DavLocatorFactory getLocatorFactory() {
        if (this.locatorFactory == null) {
            this.locatorFactory = new VfsDavLocatorFactory(this.getServletName());
        }
        return this.locatorFactory;
    }

    public void setLocatorFactory(DavLocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public LockManager getLockManager() {
        if (this.lockManager == null) {
            this.lockManager = new SimpleLockManager();
        }
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public DavResourceFactory getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new VfsDavResourceFactory(this.getLockManager(), this.root);
        }
        return this.resourceFactory;
    }

    public void setResourceFactory(DavResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public UserAuthenticator getUserAuthenticator() {
        return this.userAuthenticator;
    }

    public void setUserAuthenticator(UserAuthenticator userAuthenticator) {
        this.userAuthenticator = userAuthenticator;
    }

    public FileSystemOptions getFileSystemOptions() throws FileSystemException {
        if (this.fileSystemOptions == null) {
            this.fileSystemOptions = new FileSystemOptions();
            ZipFileSystemConfigBuilder zipBuilder = ZipFileSystemConfigBuilder.getInstance();
            zipBuilder.setCharset(this.fileSystemOptions, StandardCharsets.UTF_8);
            FtpsFileSystemConfigBuilder ftpsBuilder = FtpsFileSystemConfigBuilder.getInstance();
            ftpsBuilder.setConnectTimeout(this.fileSystemOptions, Integer.valueOf(5000));
            ftpsBuilder.setUserDirIsRoot(this.fileSystemOptions, false);
            ftpsBuilder.setAutodetectUtf8(this.fileSystemOptions, Boolean.valueOf(true));
            ftpsBuilder.setPassiveMode(this.fileSystemOptions, true);
            ftpsBuilder.setControlEncoding(this.fileSystemOptions, StandardCharsets.UTF_8.name());
            SftpFileSystemConfigBuilder sftpBuilder = SftpFileSystemConfigBuilder.getInstance();
            sftpBuilder.setConnectTimeoutMillis(this.fileSystemOptions, Integer.valueOf(5000));
            sftpBuilder.setUserDirIsRoot(this.fileSystemOptions, false);
            sftpBuilder.setStrictHostKeyChecking(this.fileSystemOptions, "no");
            Webdav4FileSystemConfigBuilder webdavBuilder = Webdav4FileSystemConfigBuilder.getInstance();
            webdavBuilder.setConnectionTimeout(this.fileSystemOptions, 50000);
            webdavBuilder.setSoTimeout(this.fileSystemOptions, 50000);
            webdavBuilder.setMaxConnectionsPerHost(this.fileSystemOptions, 1000);
            webdavBuilder.setMaxTotalConnections(this.fileSystemOptions, 1000);
            webdavBuilder.setHostnameVerificationEnabled(this.fileSystemOptions, false);
            webdavBuilder.setPreemptiveAuth(this.fileSystemOptions, true);
            webdavBuilder.setUrlCharset(this.fileSystemOptions, StandardCharsets.UTF_8.name());
            webdavBuilder.setFollowRedirect(this.fileSystemOptions, true);
            webdavBuilder.setKeepAlive(this.fileSystemOptions, true);
        }
        if (this.userAuthenticator != null) {
            DefaultFileSystemConfigBuilder defaultBuilder = DefaultFileSystemConfigBuilder.getInstance();
            defaultBuilder.setUserAuthenticator(this.fileSystemOptions, this.userAuthenticator);
        }
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public void setFilesCache(FilesCache filesCache) {
        this.filesCache = filesCache;
    }

    public FilesCache getFilesCache() {
        if (this.filesCache == null) {
            this.filesCache = new SoftRefFilesCache();
        }
        return this.filesCache;
    }

    public CacheStrategy getCacheStrategy() {
        if (this.cacheStrategy == null) {
            this.cacheStrategy = CacheStrategy.ON_CALL;
        }
        return this.cacheStrategy;
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public FileSystemManager getFileSystemManager() throws FileSystemException {
        if (this.fileSystemManager == null) {
            StandardFileSystemManager manager = new StandardFileSystemManager();
            manager.setFilesCache(this.getFilesCache());
            manager.setCacheStrategy(this.getCacheStrategy());
            manager.init();
            this.fileSystemManager = manager;
        }
        return this.fileSystemManager;
    }

    public void setFileSystemManager(FileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLogger(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public List<String> getAuditMethods() {
        return this.auditMethods;
    }

    public void setAuditMethods(List<String> auditMethods) {
        this.auditMethods = auditMethods;
    }

    public void setAuditMethods(String auditMethodsStr) {
        this.auditMethods = Arrays.asList(auditMethodsStr.split(","));
    }

    public String getInitParameter(String key) {
        String value = super.getInitParameter(key);
        if (value == null && key.equals("authenticate-header")) {
            return "Basic realm=\"Webdav VFS\"";
        }
        if (value == null && key.equals("createAbsoluteURI")) {
            return "false";
        }
        if (value == null && key.equals("csrf-protection")) {
            return "disabled";
        }
        return value;
    }

    public void init(ServletConfig config) throws ServletException {
        String includeContextPathValue;
        String listingsDirectoryValue;
        String auditMethodsValue;
        String message = "Servlet '" + config.getServletName() + "' initialization error";
        String loggerValue = this.getProperty(config.getInitParameter(INIT_PARAM_LOGGER));
        if (loggerValue != null && !loggerValue.isEmpty()) {
            this.setLogger(loggerValue);
        }
        if ((auditMethodsValue = this.getProperty(config.getInitParameter(INIT_PARAM_AUDMETHODS))) != null && !auditMethodsValue.isEmpty()) {
            this.setAuditMethods(auditMethodsValue);
        }
        this.rootpath = this.getProperty(config.getInitParameter(INIT_PARAM_ROOTPATH));
        if (this.rootpath == null) {
            throw new ServletException(message + ", init parameter '" + INIT_PARAM_ROOTPATH + "' is null");
        }
        if (this.rootpath.startsWith("./")) {
            this.rootpath = new File(this.rootpath).getAbsolutePath();
        }
        if ((listingsDirectoryValue = this.getProperty(config.getInitParameter(INIT_PARAM_LISTINGS))) != null) {
            this.listingsDirectory = Boolean.parseBoolean(listingsDirectoryValue);
        }
        if ((includeContextPathValue = this.getProperty(config.getInitParameter(INIT_PARAM_INCTXPATH))) != null) {
            this.includeContextPath = Boolean.parseBoolean(includeContextPathValue);
        }
        String builderValue = this.getProperty(config.getInitParameter(INIT_PARAM_BUILDER));
        if (this.fileSystemOptions == null && builderValue != null) {
            try {
                this.invokeFileSystemBuilder(builderValue, config);
            }
            catch (Exception e) {
                throw new ServletException(message, (Throwable)e);
            }
        }
        if (this.userAuthenticator == null) {
            String domain = this.getProperty(config.getInitParameter(INIT_PARAM_DOMAIN));
            String login = this.getProperty(config.getInitParameter(INIT_PARAM_LOGIN));
            String password = this.getProperty(config.getInitParameter(INIT_PARAM_PASSWORD));
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(domain, login, password);
            this.setUserAuthenticator((UserAuthenticator)userAuthenticator);
        }
        String filesCacheValue = this.getProperty(config.getInitParameter(INIT_PARAM_FILESCACHE));
        if (this.filesCache == null && filesCacheValue != null) {
            try {
                Class<?> filesCacheClass = Class.forName(filesCacheValue);
                this.setFilesCache((FilesCache)filesCacheClass.newInstance());
            }
            catch (Exception e) {
                throw new ServletException(message, (Throwable)e);
            }
        }
        String cacheStrategyValue = this.getProperty(config.getInitParameter(INIT_PARAM_CACHESTRATEGY));
        if (this.cacheStrategy == null && cacheStrategyValue != null) {
            if ("manual".equals(cacheStrategyValue)) {
                this.setCacheStrategy(CacheStrategy.MANUAL);
            } else if ("onresolve".equals(cacheStrategyValue)) {
                this.setCacheStrategy(CacheStrategy.ON_RESOLVE);
            } else if ("oncall".equals(cacheStrategyValue)) {
                this.setCacheStrategy(CacheStrategy.ON_CALL);
            } else {
                throw new ServletException(message + ", cache strategy '" + cacheStrategyValue + "' not valid");
            }
        }
        try {
            this.root = this.getFileSystemManager().resolveFile(this.rootpath, this.getFileSystemOptions());
            if (this.root == null || !this.root.exists()) {
                throw new ServletException(message + ", VFS root file not exist or null");
            }
        }
        catch (FileSystemException e) {
            throw new ServletException(message, (Throwable)e);
        }
        this.logger.info("Init servlet: {}, rootpath: {}, listingsDirectory: {}, version: {}", new Object[]{config.getServletName(), this.root.getPublicURIString(), this.listingsDirectory, VERSION});
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.includeContextPath) {
                1 wrapper = new /* Unavailable Anonymous Inner Class!! */;
                super.service((HttpServletRequest)wrapper, response);
            } else {
                super.service(request, response);
            }
            if (this.auditMethods == null || !this.auditMethods.contains(request.getMethod())) return;
        }
        catch (Throwable throwable) {
            if (this.auditMethods == null || !this.auditMethods.contains(request.getMethod())) throw throwable;
            String user = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : request.getRemoteUser();
            String id = request.getSession(false) != null ? request.getSession(false).getId() : null;
            String requestURI = Text.unescape((String)request.getRequestURI());
            String dest = request.getHeader("Destination");
            if (dest != null) {
                dest = Text.unescape((String)dest.replaceAll("^http.*://.*?/", "/"));
            }
            String msg = response.getStatus() + " " + request.getMethod() + " : " + requestURI + (dest != null ? ", Destination: " + dest : "") + ", User: " + user + ", ID: " + id + ", Addr: " + request.getRemoteAddr();
            this.logger.info(msg);
            throw throwable;
        }
        String user = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : request.getRemoteUser();
        String id = request.getSession(false) != null ? request.getSession(false).getId() : null;
        String requestURI = Text.unescape((String)request.getRequestURI());
        String dest = request.getHeader("Destination");
        if (dest != null) {
            dest = Text.unescape((String)dest.replaceAll("^http.*://.*?/", "/"));
        }
        String msg = response.getStatus() + " " + request.getMethod() + " : " + requestURI + (dest != null ? ", Destination: " + dest : "") + ", User: " + user + ", ID: " + id + ", Addr: " + request.getRemoteAddr();
        this.logger.info(msg);
    }

    protected void doGet(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException, DavException {
        if (this.listingsDirectory && resource.exists() && resource.isCollection()) {
            this.listingsDirectory(request, response, resource);
            return;
        }
        super.doGet(request, response, resource);
    }

    public void destroy() {
        this.logger.info("Destroy servlet: {}, rootpath: {}, listingsDirectory: {}, version: {}", new Object[]{this.getServletConfig() != null ? this.getServletName() : this, this.root != null ? this.root.getPublicURIString() : this.root, this.listingsDirectory, VERSION});
        if (this.fileSystemManager != null) {
            if (this.root != null) {
                this.fileSystemManager.closeFileSystem(this.root.getFileSystem());
            }
            this.fileSystemManager.close();
        }
        super.destroy();
    }

    protected String getProperty(String key) {
        if (key != null && key.startsWith("${") && key.endsWith("}")) {
            key = System.getProperty(key.substring(2, key.length() - 1));
        }
        return key;
    }

    private void invokeFileSystemBuilder(String builderValue, ServletConfig config) throws Exception {
        Class<?> builderClass = Class.forName(builderValue);
        Object builder = builderClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        this.fileSystemOptions = new FileSystemOptions();
        ArrayList<String> keys = Collections.list(config.getInitParameterNames());
        for (String key : keys) {
            Method m;
            if (key == null || !key.startsWith("builder.")) continue;
            String name = key.replaceAll("^builder\\.", "");
            name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
            String param = this.getProperty(config.getInitParameter(key));
            Object value = param;
            if ("true".equalsIgnoreCase(param) || "false".equalsIgnoreCase(param)) {
                value = Boolean.valueOf(param);
                try {
                    m = builderClass.getMethod(name, FileSystemOptions.class, Boolean.TYPE);
                }
                catch (NoSuchMethodException e) {
                    m = builderClass.getMethod(name, FileSystemOptions.class, Boolean.class);
                }
            } else {
                try {
                    value = Integer.parseInt(param);
                    try {
                        m = builderClass.getMethod(name, FileSystemOptions.class, Integer.TYPE);
                    }
                    catch (NoSuchMethodException e) {
                        m = builderClass.getMethod(name, FileSystemOptions.class, Integer.class);
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        value = Long.parseLong(param);
                        try {
                            m = builderClass.getMethod(name, FileSystemOptions.class, Long.TYPE);
                        }
                        catch (NoSuchMethodException nsme) {
                            m = builderClass.getMethod(name, FileSystemOptions.class, Long.class);
                        }
                    }
                    catch (NumberFormatException e1) {
                        try {
                            m = builderClass.getMethod(name, FileSystemOptions.class, String.class);
                        }
                        catch (NoSuchMethodException nsme) {
                            m = builderClass.getMethod(name, FileSystemOptions.class, Object.class);
                        }
                    }
                }
            }
            this.logger.trace("# builder: {}, {}, {}, {}", new Object[]{key, name, value, value.getClass()});
            m.invoke(builder, this.fileSystemOptions, value);
        }
    }

    protected void listingsDirectory(WebdavRequest request, WebdavResponse response, DavResource resource) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<title>" + this.getServletConfig().getServletName() + "</title>");
        sb.append("<style type=\"text/css\">");
        sb.append(this.getCSS());
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        String resourcePath = resource.getResourcePath().endsWith("/") ? resource.getResourcePath() : resource.getResourcePath() + "/";
        sb.append("<h2>Content of folder: " + resourcePath + "</h2>");
        sb.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Name");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Size");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Type");
        sb.append("</strong></font></td>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("Modified");
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        sb.append("<tr><td colspan=\"4\"><a href=\"../\"><tt>[Parent]</tt></a></td></tr>");
        String baseDir = request.getRequestURI().endsWith("/") ? request.getRequestURI() : request.getRequestURI() + "/";
        boolean isEven = false;
        DavResourceIterator resources = resource.getMembers();
        ArrayList list = new ArrayList();
        resources.forEachRemaining(list::add);
        Collections.sort(list, (d1, d2) -> d1.getDisplayName().compareTo(d2.getDisplayName()));
        for (DavResource res : list) {
            DavProperty prop;
            isEven = !isEven;
            long lastModified = res.getModificationTime();
            boolean isDir = res.isCollection();
            String name = !isDir ? res.getDisplayName() : res.getDisplayName() + "/";
            sb.append("<tr " + (isEven ? "bgcolor=\"#eeeeee\"" : "") + "\">");
            sb.append("<td>").append("<a href=\"");
            sb.append(baseDir + name);
            sb.append("\"><tt>");
            sb.append(name);
            sb.append("</tt></a></td>");
            if (isDir) {
                sb.append("<td><tt>Folder</tt></td>");
            } else {
                prop = res.getProperty(DavPropertyName.GETCONTENTLENGTH);
                String value = prop != null ? (String)prop.getValue() : null;
                long length = value != null ? Long.valueOf(value) : 0L;
                sb.append("<td><tt>").append(this.renderSize(length)).append("</tt></td>");
            }
            if (isDir) {
                sb.append("<td><tt>-</tt></td>");
            } else {
                sb.append("<td><tt>");
                prop = res.getProperty(DavPropertyName.GETCONTENTTYPE);
                String mimeType = prop != null ? (String)prop.getValue() : "Unknown type";
                sb.append(mimeType);
                sb.append("</tt></td>");
            }
            sb.append("<td><tt>");
            sb.append(shortDF.format(lastModified));
            sb.append("</tt></td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        sb.append("<h3 id=\"version\" value=\"" + VERSION + "\">Application version: " + VERSION + "</h3>");
        sb.append("</body></html>");
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().print(sb.toString());
    }

    protected String getCSS() {
        return CSS;
    }

    protected String renderSize(long size) {
        long leftSide = size / 1024L;
        long rightSide = size % 1024L / 103L;
        if (leftSide == 0L && rightSide == 0L && size > 0L) {
            rightSide = 1L;
        }
        return "" + leftSide + "." + rightSide + " kb";
    }

    static {
        StringBuffer sb = new StringBuffer();
        sb.append("h1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} ");
        sb.append("h2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} ");
        sb.append("h3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} ");
        sb.append("body {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} ");
        sb.append("b {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} ");
        sb.append("p {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;} ");
        sb.append("a {color:black;} a.name {color:black;} ");
        sb.append(".line {height:1px;background-color:#525D76;border:none;}");
        CSS = sb.toString();
    }
}

