/*
 * Decompiled with CFR 0.152.
 */
package com.github.lfopenjavaswagger2word.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.lfopenjavaswagger2word.model.ModelAttr;
import com.github.lfopenjavaswagger2word.model.Request;
import com.github.lfopenjavaswagger2word.model.Response;
import com.github.lfopenjavaswagger2word.util.CollectionUtils;
import com.github.lfopenjavaswagger2word.util.DateUtils;
import com.github.lfopenjavaswagger2word.util.DocxUtils;
import com.github.lfopenjavaswagger2word.util.JsonUtils;
import com.github.lfopenjavaswagger2word.util.SetDocxConf;
import com.github.lfopenjavaswagger2word.util.TextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class GenerateDocxUtils {
    public static boolean generateFile(String file) {
        try {
            String reader = TextUtil.reader(file);
            ObjectMapper om = new ObjectMapper();
            SetDocxConf instance = SetDocxConf.getInstance();
            HashMap<String, List<Map<String, Object>>> mappAll = new HashMap<String, List<Map<String, Object>>>();
            Map map = (Map)om.readValue(reader, HashMap.class);
            String host = map.get("host").toString();
            Map<String, String> mapIndex = GenerateDocxUtils.parseWordIndex(map);
            GenerateDocxUtils.generateDocContent(mappAll, map, host);
            DocxUtils.generateDoc(instance, mappAll, mapIndex);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean generateFileByJSON(String reader) {
        try {
            if (TextUtil.isBlank(reader)) {
                throw new Exception("jsonstr cannot null\uff01");
            }
            ObjectMapper om = new ObjectMapper();
            SetDocxConf instance = SetDocxConf.getInstance();
            HashMap<String, List<Map<String, Object>>> mappAll = new HashMap<String, List<Map<String, Object>>>();
            Map map = (Map)om.readValue(reader, HashMap.class);
            String host = map.get("host").toString();
            Map<String, String> mapIndex = GenerateDocxUtils.parseWordIndex(map);
            GenerateDocxUtils.generateDocContent(mappAll, map, host);
            DocxUtils.generateDoc(instance, mappAll, mapIndex);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static XWPFDocument generateXWPFDocumentByJSON(String reader) {
        try {
            if (TextUtil.isBlank(reader)) {
                throw new Exception("jsonstr cannot null\uff01");
            }
            ObjectMapper om = new ObjectMapper();
            SetDocxConf instance = SetDocxConf.getInstance();
            HashMap<String, List<Map<String, Object>>> mappAll = new HashMap<String, List<Map<String, Object>>>();
            Map map = (Map)om.readValue(reader, HashMap.class);
            String host = map.get("host").toString();
            Map<String, String> mapIndex = GenerateDocxUtils.parseWordIndex(map);
            GenerateDocxUtils.generateDocContent(mappAll, map, host);
            XWPFDocument xwpfDocument = DocxUtils.getXWPFDocument(instance, mappAll, mapIndex);
            return xwpfDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XWPFDocument generateXWPFDocument(String file) {
        try {
            String reader = TextUtil.reader(file);
            ObjectMapper om = new ObjectMapper();
            SetDocxConf instance = SetDocxConf.getInstance();
            HashMap<String, List<Map<String, Object>>> mappAll = new HashMap<String, List<Map<String, Object>>>();
            Map map = (Map)om.readValue(reader, HashMap.class);
            String host = map.get("host").toString();
            Map<String, String> mapIndex = GenerateDocxUtils.parseWordIndex(map);
            GenerateDocxUtils.generateDocContent(mappAll, map, host);
            XWPFDocument xwpfDocument = DocxUtils.getXWPFDocument(instance, mappAll, mapIndex);
            return xwpfDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void generateDocContent(Map<String, List<Map<String, Object>>> mappAll, Map<String, Object> map, String host) throws IOException {
        Map<String, ModelAttr> definitinMap = GenerateDocxUtils.parseDefinitions(map);
        Map paths = (Map)map.get("paths");
        if (paths != null) {
            for (Map.Entry path : paths.entrySet()) {
                List<Map<String, Object>> list1;
                String title;
                ArrayList<Map<String, Object>> reqList = new ArrayList<Map<String, Object>>();
                ArrayList<Map<String, Object>> resList = new ArrayList<Map<String, Object>>();
                Iterator it2 = ((Map)path.getValue()).entrySet().iterator();
                String url = (String)path.getKey();
                String requestType = TextUtil.join(((Map)path.getValue()).keySet(), ",");
                Map.Entry firstRequest = it2.next();
                Map content = (Map)firstRequest.getValue();
                String tag = String.valueOf(content.get("summary"));
                String description = String.valueOf(content.get("description"));
                String requestForm = "";
                List consumes = (List)content.get("consumes");
                if (consumes != null && consumes.size() > 0) {
                    requestForm = TextUtil.join(consumes, ",");
                }
                String responseForm = "";
                List produces = (List)content.get("produces");
                if (produces != null && produces.size() > 0) {
                    responseForm = TextUtil.join(produces, ",");
                }
                if ((title = String.valueOf(((List)content.get("tags")).get(0))) == null || title.equals("")) {
                    list1 = mappAll.get("\u5176\u4ed6\u63a5\u53e3\uff1a\u65e0\u7c7b\u8bf4\u660e");
                    if (list1 == null) {
                        list1 = new ArrayList<Map<String, Object>>();
                        mappAll.put("\u5176\u4ed6\u63a5\u53e3\uff1a\u65e0\u7c7b\u8bf4\u660e", list1);
                    }
                } else {
                    list1 = mappAll.get(title);
                    if (list1 == null) {
                        list1 = new ArrayList<Map<String, Object>>();
                        mappAll.put(title, list1);
                    }
                }
                ArrayList parameters = (ArrayList)content.get("parameters");
                ArrayList<Request> requestList = new ArrayList<Request>();
                if (parameters != null && parameters.size() > 0) {
                    for (int i = 0; i < parameters.size(); ++i) {
                        String type;
                        String firstSuffix = i + ".";
                        Map param = (Map)parameters.get(i);
                        Object in = param.get("in");
                        HashMap<String, String> mreqMap = new HashMap<String, String>();
                        mreqMap.put("\u53c2\u6570\u7c7b\u578b", String.valueOf(in));
                        mreqMap.put("\u53c2\u6570\u540d", firstSuffix + String.valueOf(param.get("name")));
                        mreqMap.put("\u8bf4\u660e", String.valueOf(param.get("description")));
                        String string = type = param.get("type") == null ? "object" : param.get("type").toString();
                        if (param.get("format") != null) {
                            type = TextUtil.concat(type, "(", param.get("format").toString(), ")");
                        }
                        mreqMap.put("\u6570\u636e\u7c7b\u578b", type);
                        mreqMap.put("\u662f\u5426\u5fc5\u586b", param.get("required") != null ? param.get("required").toString().concat("") : "false");
                        if (in != null && "body".equals(in)) {
                            Map schema = (Map)param.get("schema");
                            Object ref = schema.get("$ref");
                            if (schema.get("type") != null && "array".equals(schema.get("type"))) {
                                ref = ((Map)schema.get("items")).get("$ref");
                                mreqMap.put("\u6570\u636e\u7c7b\u578b", "array");
                            }
                            if (ref != null) {
                                mreqMap.put("\u6570\u636e\u7c7b\u578b", mreqMap.get("\u6570\u636e\u7c7b\u578b").toString().concat(":").concat(ref.toString().replaceAll("#/definitions/", "")));
                                ModelAttr modelAttr = definitinMap.get(ref);
                                List<ModelAttr> properties = modelAttr.getProperties();
                                GenerateDocxUtils.addReqParam(reqList, firstSuffix, in, properties);
                            }
                        }
                        reqList.add(mreqMap);
                        Request request = new Request();
                        request.setName(String.valueOf(param.get("name")));
                        request.setType(param.get("type") == null ? "object" : param.get("type").toString());
                        if (param.get("format") != null) {
                            request.setType(request.getType() + "(" + param.get("format") + ")");
                        }
                        request.setParamType(String.valueOf(in));
                        if (in != null && "body".equals(in)) {
                            Map schema = (Map)param.get("schema");
                            Object ref = schema.get("$ref");
                            if (schema.get("type") != null && "array".equals(schema.get("type"))) {
                                ref = ((Map)schema.get("items")).get("$ref");
                                request.setType("array");
                            }
                            if (ref != null) {
                                request.setType(request.getType() + ":" + ref.toString().replaceAll("#/definitions/", ""));
                                request.setModelAttr(definitinMap.get(ref));
                            }
                        }
                        request.setRequire(false);
                        if (param.get("required") != null) {
                            request.setRequire((Boolean)param.get("required"));
                        }
                        request.setRemark(String.valueOf(param.get("description")));
                        requestList.add(request);
                    }
                }
                LinkedHashMap responses = (LinkedHashMap)content.get("responses");
                GenerateDocxUtils.processResponseCodeList(responses);
                Map obj = (Map)responses.get("200");
                if (obj != null && obj.get("schema") != null) {
                    ModelAttr attr = GenerateDocxUtils.processResponseModelAttrs(obj, definitinMap);
                    List<ModelAttr> properties = attr.getProperties();
                    if (properties == null || properties.size() == 0) {
                        HashMap<String, String> mresMap = new HashMap<String, String>();
                        mresMap.put("\u8bf4\u660e", attr.getDescription() == null ? "" : attr.getDescription());
                        mresMap.put("\u6570\u636e\u7c7b\u578b", attr.getType());
                        mresMap.put("\u53c2\u6570\u540d", "[\u65e0\u540d\u79f0]");
                        resList.add(mresMap);
                    } else {
                        GenerateDocxUtils.addResParam(resList, null, properties);
                    }
                }
                String reqExam = GenerateDocxUtils.processRequestParam(requestList);
                String resExam = GenerateDocxUtils.processResponseParam(obj, definitinMap);
                DocxUtils.addList(list1, reqList, resList, tag, description, host.concat(url), requestType, requestForm, reqExam, resExam, responseForm);
            }
        }
    }

    private static String processResponseParam(Map<String, Object> responseObj, Map<String, ModelAttr> definitinMap) throws JsonProcessingException {
        if (responseObj != null && responseObj.get("schema") != null) {
            ModelAttr modelAttr;
            Map items;
            Map schema = (Map)responseObj.get("schema");
            String type = (String)schema.get("type");
            String ref = null;
            if ("array".equals(type) && (items = (Map)schema.get("items")) != null && items.get("$ref") != null) {
                ref = (String)items.get("$ref");
            }
            if (schema.get("$ref") != null) {
                ref = (String)schema.get("$ref");
            }
            if (TextUtil.isNotEmpty(ref) && (modelAttr = definitinMap.get(ref)) != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                HashMap<String, Object> responseMap = new HashMap<String, Object>(8);
                for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                    responseMap.put(subModelAttr.getName(), GenerateDocxUtils.getValue(subModelAttr.getType(), subModelAttr));
                }
                return JsonUtils.writeJsonStr(responseMap);
            }
        }
        return "";
    }

    private static ModelAttr processResponseModelAttrs(Map<String, Object> responseObj, Map<String, ModelAttr> definitinMap) {
        Map items;
        Map schema = (Map)responseObj.get("schema");
        String type = (String)schema.get("type");
        String ref = null;
        if ("array".equals(type) && (items = (Map)schema.get("items")) != null && items.get("$ref") != null) {
            ref = (String)items.get("$ref");
        }
        if (schema.get("$ref") != null) {
            ref = (String)schema.get("$ref");
        }
        ModelAttr modelAttr = new ModelAttr();
        modelAttr.setType(TextUtil.defaultIfBlank(type, ""));
        if (!TextUtil.isBlank(ref) && definitinMap.get(ref) != null) {
            modelAttr = definitinMap.get(ref);
        }
        return modelAttr;
    }

    private static String processRequestParam(List<Request> list) throws IOException {
        LinkedHashMap<String, Object> headerMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> queryMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        if (list != null && list.size() > 0) {
            for (Request request : list) {
                String name = request.getName();
                String paramType = request.getParamType();
                Object value = GenerateDocxUtils.getValue(request.getType(), request.getModelAttr());
                switch (paramType) {
                    case "header": {
                        headerMap.put(name, value);
                        break;
                    }
                    case "query": {
                        queryMap.put(name, value);
                        break;
                    }
                    case "body": {
                        jsonMap.put(name, value);
                        break;
                    }
                }
            }
        }
        String res = "";
        if (!queryMap.isEmpty()) {
            res = res + GenerateDocxUtils.getUrlParamsByMap(queryMap);
        }
        if (!headerMap.isEmpty()) {
            res = res + " " + GenerateDocxUtils.getHeaderByMap(headerMap);
        }
        if (!jsonMap.isEmpty()) {
            if (jsonMap.size() == 1) {
                for (Map.Entry entry : jsonMap.entrySet()) {
                    res = res + " -d '" + JsonUtils.writeJsonStr(entry.getValue()) + "'";
                }
            } else {
                res = res + " -d '" + JsonUtils.writeJsonStr(jsonMap) + "'";
            }
        }
        return res;
    }

    public static String getUrlParamsByMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("&");
        }
        String s = sb.toString();
        if (s.endsWith("&")) {
            s = TextUtil.substringBeforeLast(s, "&");
        }
        return s;
    }

    public static String getHeaderByMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("--header '");
            sb.append(entry.getKey() + ":" + entry.getValue());
            sb.append("'");
        }
        return sb.toString();
    }

    private static Object getValue(String type, ModelAttr modelAttr) {
        int pos = type.indexOf(":");
        if (pos != -1) {
            type = type.substring(0, pos);
        }
        switch (type) {
            case "string": {
                return "string";
            }
            case "string(date-time)": {
                return "2020/01/01 00:00:00";
            }
            case "integer": 
            case "integer(int64)": 
            case "integer(int32)": {
                return 0;
            }
            case "number": {
                return 0.0;
            }
            case "boolean": {
                return true;
            }
            case "file": {
                return "(binary)";
            }
            case "array": {
                ArrayList list = new ArrayList();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (modelAttr != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                    for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                        map.put(subModelAttr.getName(), GenerateDocxUtils.getValue(subModelAttr.getType(), subModelAttr));
                    }
                }
                list.add(map);
                return list;
            }
            case "object": {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                if (modelAttr != null && !CollectionUtils.isEmpty(modelAttr.getProperties())) {
                    for (ModelAttr subModelAttr : modelAttr.getProperties()) {
                        map.put(subModelAttr.getName(), GenerateDocxUtils.getValue(subModelAttr.getType(), subModelAttr));
                    }
                }
                return map;
            }
        }
        return null;
    }

    private static List<Response> processResponseCodeList(Map<String, Object> responses) {
        ArrayList<Response> responseList = new ArrayList<Response>();
        for (Map.Entry<String, Object> entry : responses.entrySet()) {
            Response response = new Response();
            response.setName(entry.getKey());
            LinkedHashMap statusCodeInfo = (LinkedHashMap)entry.getValue();
            response.setDescription(String.valueOf(statusCodeInfo.get("description")));
            Object schema = statusCodeInfo.get("schema");
            if (schema != null) {
                Object originalRef = ((LinkedHashMap)schema).get("originalRef");
                response.setRemark(originalRef == null ? "" : originalRef.toString());
            }
            responseList.add(response);
        }
        return responseList;
    }

    private static void addReqParam(List<Map<String, Object>> reqList, String firstSuffix, Object in, List<ModelAttr> properties) {
        if (properties != null && properties.size() > 0) {
            for (int j = 0; j < properties.size(); ++j) {
                ModelAttr attr = properties.get(j);
                HashMap<String, Object> mreqChild = new HashMap<String, Object>();
                String secondSuffix = TextUtil.addBlank(TextUtil.concat(firstSuffix, j + "."), 1);
                mreqChild.put("\u53c2\u6570\u540d", TextUtil.concat(secondSuffix, attr.getName()));
                mreqChild.put("\u53c2\u6570\u7c7b\u578b", String.valueOf(in));
                mreqChild.put("\u6570\u636e\u7c7b\u578b", attr.getType());
                mreqChild.put("\u662f\u5426\u5fc5\u586b", attr.getRequire());
                mreqChild.put("\u8bf4\u660e", attr.getDescription() == null ? "" : attr.getDescription());
                reqList.add(mreqChild);
                List<ModelAttr> properties1 = attr.getProperties();
                GenerateDocxUtils.addReqParam(reqList, secondSuffix, in, properties1);
            }
        }
    }

    private static void addResParam(List<Map<String, Object>> resList, String firstSuffix, List<ModelAttr> properties) {
        if (properties != null && properties.size() > 0) {
            for (int j = 0; j < properties.size(); ++j) {
                ModelAttr attr = properties.get(j);
                HashMap<String, String> mreqChild = new HashMap<String, String>();
                String secondSuffix = firstSuffix == null ? TextUtil.concat(j + ".") : TextUtil.addBlank(TextUtil.concat(firstSuffix, j + "."), 1);
                mreqChild.put("\u53c2\u6570\u540d", TextUtil.concat(secondSuffix, attr.getName()));
                mreqChild.put("\u6570\u636e\u7c7b\u578b", attr.getType());
                mreqChild.put("\u8bf4\u660e", attr.getDescription() == null ? "" : attr.getDescription());
                resList.add(mreqChild);
                List<ModelAttr> properties1 = attr.getProperties();
                GenerateDocxUtils.addResParam(resList, secondSuffix, properties1);
            }
        }
    }

    private static Map<String, String> parseWordIndex(Map<String, Object> map) {
        HashMap<String, String> mapIndex = new HashMap<String, String>();
        String swagger = map.get("swagger").toString();
        Map info = (Map)map.get("info");
        String description1 = (String)info.get("description");
        String version = (String)info.get("version");
        String title1 = (String)info.get("title");
        Map map1 = (Map)info.get("contact");
        String name = (String)map1.get("name");
        String url1 = (String)map1.get("url");
        String email = (String)map1.get("email");
        mapIndex.put("title", title1);
        mapIndex.put("desc", description1);
        mapIndex.put("version_swagger", swagger);
        mapIndex.put("version_docx", version);
        mapIndex.put("name", name);
        mapIndex.put("url", url1);
        mapIndex.put("email", email);
        mapIndex.put("time", SetDocxConf.getInstance().getDocxTimeValue() == null ? DateUtils.now(null) : SetDocxConf.getInstance().getDocxTimeValue());
        return mapIndex;
    }

    private static Map<String, ModelAttr> parseDefinitions(Map<String, Object> map) {
        Map definitions = (Map)map.get("definitions");
        HashMap<String, ModelAttr> definitinMap = new HashMap<String, ModelAttr>(256);
        if (definitions != null) {
            for (String modeName : definitions.keySet()) {
                GenerateDocxUtils.getAndPutModelAttr(definitions, definitinMap, modeName);
            }
        }
        return definitinMap;
    }

    private static ModelAttr getAndPutModelAttr(Map<String, Map<String, Object>> swaggerMap, Map<String, ModelAttr> resMap, String modeName) {
        ModelAttr modeAttr = resMap.get("#/definitions/" + modeName);
        if (modeAttr == null) {
            modeAttr = new ModelAttr();
            resMap.put("#/definitions/" + modeName, modeAttr);
        } else if (modeAttr.isCompleted()) {
            return resMap.get("#/definitions/" + modeName);
        }
        Map modeProperties = (Map)swaggerMap.get(modeName).get("properties");
        if (modeProperties == null) {
            return null;
        }
        Iterator mIt = modeProperties.entrySet().iterator();
        ArrayList<ModelAttr> attrList = new ArrayList<ModelAttr>();
        while (mIt.hasNext()) {
            Map.Entry mEntry = mIt.next();
            Map attrInfoMap = (Map)mEntry.getValue();
            ModelAttr child = new ModelAttr();
            child.setName((String)mEntry.getKey());
            child.setType((String)attrInfoMap.get("type"));
            if (attrInfoMap.get("format") != null) {
                child.setType(child.getType() + "(" + attrInfoMap.get("format") + ")");
            }
            String finalType = "object";
            if (child.getType() != null && child.getType().equals("")) {
                child.setType(finalType);
            }
            Object ref = attrInfoMap.get("$ref");
            Object items = attrInfoMap.get("items");
            if (ref != null || items != null && (ref = ((Map)items).get("$ref")) != null) {
                String refName = ref.toString();
                String clsName = refName.substring(14);
                modeAttr.setCompleted(true);
                ModelAttr refModel = GenerateDocxUtils.getAndPutModelAttr(swaggerMap, resMap, clsName);
                if (refModel != null) {
                    child.setProperties(refModel.getProperties());
                }
                child.setType(child.getType() + ":" + clsName);
            }
            child.setDescription((String)attrInfoMap.get("description"));
            attrList.add(child);
        }
        Object title = swaggerMap.get(modeName).get("title");
        Object description = swaggerMap.get(modeName).get("description");
        modeAttr.setClassName(title == null ? "" : title.toString());
        modeAttr.setDescription(description == null ? "" : description.toString());
        modeAttr.setProperties(attrList);
        return modeAttr;
    }
}

