/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_concat", value="_FUNC_(array, array) - concatenates two arrays.", extended="Example:\n > select _FUNC_(array, array) from src;")
public class UDFArrayConcat
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private transient ListObjectInspector leftArrayOI;
    private transient ListObjectInspector rightArrayOI;
    private transient ObjectInspector leftArrayElementOI;
    private transient ObjectInspector rightArrayElementOI;
    private transient ArrayList<Object> result = new ArrayList();
    private transient ObjectInspectorConverters.Converter converter;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_concat(array, array) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.LIST)) continue;
            throw new UDFArgumentTypeException(i, "\"array\" expected at function array_concat, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.leftArrayOI = (ListObjectInspector)arguments[0];
        this.rightArrayOI = (ListObjectInspector)arguments[1];
        this.leftArrayElementOI = this.leftArrayOI.getListElementObjectInspector();
        this.rightArrayElementOI = this.rightArrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.leftArrayElementOI, (ObjectInspector)this.rightArrayElementOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.leftArrayElementOI.getTypeName() + "\" expected at function array_concat, but \"" + this.rightArrayElementOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.leftArrayElementOI)) {
            throw new UDFArgumentException("The function array_concat does not support comparison for \"" + this.leftArrayElementOI.getTypeName() + "\" types");
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.leftArrayElementOI, (ObjectInspector)this.leftArrayElementOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.leftArrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object arrayElement;
        int i;
        Object leftArray = arguments[0].get();
        Object rightArray = arguments[1].get();
        int leftArrayLength = this.leftArrayOI.getListLength(leftArray);
        int rightArrayLength = this.rightArrayOI.getListLength(rightArray);
        if (leftArray == null || rightArray == null || leftArrayLength < 0 || rightArrayLength < 0) {
            return null;
        }
        if (leftArrayLength == 0) {
            return rightArray;
        }
        if (rightArrayLength == 0) {
            return leftArray;
        }
        this.result.clear();
        for (i = 0; i < leftArrayLength; ++i) {
            arrayElement = this.leftArrayOI.getListElement(leftArray, i);
            this.result.add(this.converter.convert(arrayElement));
        }
        for (i = 0; i < rightArrayLength; ++i) {
            arrayElement = this.rightArrayOI.getListElement(rightArray, i);
            this.result.add(this.converter.convert(arrayElement));
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_concat(" + strings[0] + ", " + strings[1] + ")";
    }
}

