/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="array_contains", value="_FUNC_(array<E>, E) - whether array contains value or not.", extended="Example:\n > select _FUNC_(array, value) from src;")
public class UDFArrayContains
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int VALUE_IDX = 1;
    private static final int ARG_COUNT = 2;
    private transient ObjectInspector valueOI;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private BooleanWritable result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_contains(array, value) takes exactly 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_contains, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.valueOI = arguments[1];
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.valueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.arrayElementOI.getTypeName() + "\" expected at function array_contains, but \"" + this.valueOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.valueOI)) {
            throw new UDFArgumentException("The function array_contains does not support comparison for \"" + this.valueOI.getTypeName() + "\" types");
        }
        this.result = new BooleanWritable(false);
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.set(false);
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null) {
            return this.result;
        }
        if (value == null || arrayLength <= 0) {
            return this.result;
        }
        for (int i = 0; i < arrayLength; ++i) {
            Object listElement = this.arrayOI.getListElement(array, i);
            if (listElement == null || ObjectInspectorUtils.compare((Object)value, (ObjectInspector)this.valueOI, (Object)listElement, (ObjectInspector)this.arrayElementOI) != 0) continue;
            this.result.set(true);
            break;
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_contains(" + strings[0] + ", " + strings[1] + ")";
    }
}

