/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="array_element_at", value="_FUNC_(array<E>, index) - returns element of array at given index. If index < 0, element_at accesses elements from the last to the first.", extended="Example:\n > select _FUNC_(array, index) from src;")
public class UDFArrayElementAt
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int INDEX_IDX = 1;
    private static final int ARG_COUNT = 2;
    private transient ObjectInspector indexOI;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_element_at(array, index) takes exactly 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_element_at, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.indexOI = arguments[1];
        WritableIntObjectInspector expectOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)expectOI, (ObjectInspector)this.indexOI)) {
            throw new UDFArgumentTypeException(1, "\"" + expectOI.getTypeName() + "\" expected at function array_element_at, but \"" + this.indexOI.getTypeName() + "\" is found");
        }
        return this.arrayElementOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        IntWritable index = (IntWritable)arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (index == null || arrayLength <= 0) {
            return null;
        }
        if (index.get() < 0) {
            int idx = arrayLength + index.get();
            if (idx >= 0) {
                return this.arrayOI.getListElement(array, idx);
            }
        } else if (index.get() < arrayLength) {
            return this.arrayOI.getListElement(array, index.get());
        }
        return null;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_element_at(" + strings[0] + ", " + strings[1] + ")";
    }
}

