/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import com.github.aaronshan.functions.utils.ArrayUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="array_equals", value="_FUNC_(array, array) - whether two arrays equals or not.", extended="Example:\n > select _FUNC_(array, array) from src;")
public class UDFArrayEquals
extends GenericUDF {
    private static final int ARG_COUNT = 2;
    private transient ListObjectInspector leftArrayOI;
    private transient ListObjectInspector rightArrayOI;
    private transient ObjectInspector leftArrayElementOI;
    private transient ObjectInspector rightArrayElementOI;
    private BooleanWritable result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_equals(array, array) takes exactly 2 arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.LIST)) continue;
            throw new UDFArgumentTypeException(i, "\"array\" expected at function array_equals, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.leftArrayOI = (ListObjectInspector)arguments[0];
        this.rightArrayOI = (ListObjectInspector)arguments[1];
        this.leftArrayElementOI = this.leftArrayOI.getListElementObjectInspector();
        this.rightArrayElementOI = this.rightArrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.leftArrayElementOI, (ObjectInspector)this.rightArrayElementOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.leftArrayElementOI.getTypeName() + "\" expected at function array_equals, but \"" + this.rightArrayElementOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.leftArrayElementOI)) {
            throw new UDFArgumentException("The function array_equals does not support comparison for \"" + this.leftArrayElementOI.getTypeName() + "\" types");
        }
        this.result = new BooleanWritable(false);
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object leftArray = arguments[0].get();
        Object rightArray = arguments[1].get();
        boolean ret = ArrayUtils.arrayEquals(leftArray, rightArray, this.leftArrayOI);
        this.result.set(ret);
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_equals(" + strings[0] + ", " + strings[1] + ")";
    }
}

