/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import com.github.aaronshan.functions.fastuitl.ints.IntArrays;
import com.github.aaronshan.functions.utils.ArrayUtils;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_intersect", value="_FUNC_(array, array) - returns the two array's intersection, without duplicates.", extended="Example:\n > select _FUNC_(array, array) from src;")
public class UDFArrayIntersect
extends GenericUDF {
    private static final int INITIAL_SIZE = 128;
    private static final int ARG_COUNT = 2;
    private int[] leftPositions = new int[128];
    private int[] rightPositions = new int[128];
    private transient ListObjectInspector leftArrayOI;
    private transient ListObjectInspector rightArrayOI;
    private transient ObjectInspector leftArrayElementOI;
    private transient ObjectInspector rightArrayElementOI;
    private transient ArrayList<Object> result = new ArrayList();
    private transient ObjectInspectorConverters.Converter converter;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_intersect(array, array) takes exactly 2arguments.");
        }
        for (int i = 0; i < 2; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.LIST)) continue;
            throw new UDFArgumentTypeException(i, "\"array\" expected at function array_intersect, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        this.leftArrayOI = (ListObjectInspector)arguments[0];
        this.rightArrayOI = (ListObjectInspector)arguments[1];
        this.leftArrayElementOI = this.leftArrayOI.getListElementObjectInspector();
        this.rightArrayElementOI = this.rightArrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.leftArrayElementOI, (ObjectInspector)this.rightArrayElementOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.leftArrayElementOI.getTypeName() + "\" expected at function array_intersect, but \"" + this.rightArrayElementOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.leftArrayElementOI)) {
            throw new UDFArgumentException("The function array_intersect does not support comparison for \"" + this.leftArrayElementOI.getTypeName() + "\" types");
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.leftArrayElementOI, (ObjectInspector)this.leftArrayElementOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.leftArrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int i;
        Object leftArray = arguments[0].get();
        Object rightArray = arguments[1].get();
        int leftArrayLength = this.leftArrayOI.getListLength(leftArray);
        int rightArrayLength = this.rightArrayOI.getListLength(rightArray);
        if (leftArray == null || rightArray == null || leftArrayLength < 0 || rightArrayLength < 0) {
            return null;
        }
        if (leftArrayLength == 0) {
            return leftArray;
        }
        if (rightArrayLength == 0) {
            return rightArray;
        }
        if (this.leftPositions.length < leftArrayLength) {
            this.leftPositions = new int[leftArrayLength];
        }
        if (this.rightPositions.length < rightArrayLength) {
            this.rightPositions = new int[rightArrayLength];
        }
        for (i = 0; i < leftArrayLength; ++i) {
            this.leftPositions[i] = i;
        }
        for (i = 0; i < rightArrayLength; ++i) {
            this.rightPositions[i] = i;
        }
        IntArrays.quickSort(this.leftPositions, 0, leftArrayLength, ArrayUtils.IntArrayCompare(leftArray, this.leftArrayOI));
        IntArrays.quickSort(this.rightPositions, 0, rightArrayLength, ArrayUtils.IntArrayCompare(rightArray, this.rightArrayOI));
        this.result.clear();
        int leftCurrentPosition = 0;
        int rightCurrentPosition = 0;
        while (leftCurrentPosition < leftArrayLength && rightCurrentPosition < rightArrayLength) {
            Object rightArrayElement;
            int leftBasePosition = leftCurrentPosition;
            int rightBasePosition = rightCurrentPosition;
            Object leftArrayElement = this.leftArrayOI.getListElement(leftArray, this.leftPositions[leftCurrentPosition]);
            int compareValue = ObjectInspectorUtils.compare((Object)leftArrayElement, (ObjectInspector)this.leftArrayElementOI, (Object)(rightArrayElement = this.rightArrayOI.getListElement(rightArray, this.rightPositions[rightCurrentPosition])), (ObjectInspector)this.rightArrayElementOI);
            if (compareValue > 0) {
                ++rightCurrentPosition;
                continue;
            }
            if (compareValue < 0) {
                ++leftCurrentPosition;
                continue;
            }
            this.result.add(this.converter.convert(this.leftArrayOI.getListElement(leftArray, this.leftPositions[leftCurrentPosition])));
            ++leftCurrentPosition;
            ++rightCurrentPosition;
            while (leftCurrentPosition < leftArrayLength && this.compare(this.leftArrayOI, leftArray, leftBasePosition, leftCurrentPosition) == 0) {
                ++leftCurrentPosition;
            }
            while (rightCurrentPosition < rightArrayLength && this.compare(this.rightArrayOI, rightArray, rightBasePosition, rightCurrentPosition) == 0) {
                ++rightCurrentPosition;
            }
        }
        return this.result;
    }

    private int compare(ListObjectInspector arrayOI, Object array, int position1, int position2) {
        ObjectInspector arrayElementOI = arrayOI.getListElementObjectInspector();
        Object arrayElementTmp1 = arrayOI.getListElement(array, this.leftPositions[position1]);
        Object arrayElementTmp2 = arrayOI.getListElement(array, this.leftPositions[position2]);
        return ObjectInspectorUtils.compare((Object)arrayElementTmp1, (ObjectInspector)arrayElementOI, (Object)arrayElementTmp2, (ObjectInspector)arrayElementOI);
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_intersect(" + strings[0] + ", " + strings[1] + ")";
    }
}

