/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="array_join", value="_FUNC_(array<E>, delimiter, null_replacement) - concatenates the elements of the given array using the delimiter and an optional null_replacement to replace nulls.", extended="Example:\n > select _FUNC_(array, delimiter) from src;\n> select _FUNC_(array, delimiter, null_replacement) from src;")
public class UDFArrayJoin
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int DELIMITER_IDX = 1;
    private static final int NULL_REPLACE_IDX = 2;
    private static final int MIN_ARG_COUNT = 2;
    private static final int MAX_ARG_COUNT = 3;
    private transient ObjectInspector delimiterOI;
    private transient ObjectInspector nullReplaceOI;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ObjectInspectorConverters.Converter delimiterConvert;
    private transient ObjectInspectorConverters.Converter nullReplaceConvert;
    private Text result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length > 3 || arguments.length < 2) {
            throw new UDFArgumentLengthException("The function array_join(array, delimiter) or array_join(array, delimiter, null_replacement) takes exactly 2 or 3 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_join, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.delimiterOI = arguments[1];
        this.delimiterConvert = ObjectInspectorConverters.getConverter((ObjectInspector)this.delimiterOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        if (arguments.length == 3) {
            this.nullReplaceOI = arguments[2];
            this.nullReplaceConvert = ObjectInspectorConverters.getConverter((ObjectInspector)this.nullReplaceOI, (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        this.result = new Text();
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.set("");
        Object array = arguments[0].get();
        Object delimiter = arguments[1].get();
        Object nullReplace = null;
        if (arguments.length == 3) {
            nullReplace = arguments[2].get();
        }
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null || arrayLength <= 0) {
            return this.result;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Object listElement = this.arrayOI.getListElement(array, 0);
        this.appendElement(stringBuffer, listElement, nullReplace);
        for (int i = 1; i < arrayLength; ++i) {
            stringBuffer.append(this.delimiterConvert.convert(delimiter));
            listElement = this.arrayOI.getListElement(array, i);
            this.appendElement(stringBuffer, listElement, nullReplace);
        }
        this.result.set(stringBuffer.toString());
        return this.result;
    }

    private void appendElement(StringBuffer stringBuffer, Object listElement, Object nullReplace) {
        if (listElement == null) {
            if (nullReplace != null) {
                stringBuffer.append(this.nullReplaceConvert.convert(nullReplace));
            } else {
                stringBuffer.append(listElement);
            }
        } else {
            stringBuffer.append(listElement);
        }
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length <= 3 || strings.length >= 2);
        if (strings.length == 2) {
            return "array_join(" + strings[0] + ", " + strings[1] + ")";
        }
        return "array_join(" + strings[0] + ", " + strings[1] + ", " + strings[2] + ")";
    }
}

