/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_remove", value="_FUNC_(array<E>, E) - remove all elements that equal element from array.", extended="Example:\n > select _FUNC_(array, value) from src;")
public class UDFArrayRemove
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int VALUE_IDX = 1;
    private static final int ARG_COUNT = 2;
    private transient ObjectInspector valueOI;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ArrayList<Object> result = new ArrayList();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_remove(array, value) takes exactly 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_remove, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.valueOI = arguments[1];
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.valueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.arrayElementOI.getTypeName() + "\" expected at function array_remove, but \"" + this.valueOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.valueOI)) {
            throw new UDFArgumentException("The function array_remove does not support comparison for \"" + this.valueOI.getTypeName() + "\" types");
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.arrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.clear();
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (value == null || arrayLength <= 0) {
            return null;
        }
        for (int i = 0; i < arrayLength; ++i) {
            Object listElement = this.arrayOI.getListElement(array, i);
            if (listElement == null || ObjectInspectorUtils.compare((Object)value, (ObjectInspector)this.valueOI, (Object)listElement, (ObjectInspector)this.arrayElementOI) == 0) continue;
            this.result.add(listElement);
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_remove(" + strings[0] + ", " + strings[1] + ")";
    }
}

