/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_reverse", value="_FUNC_(array) - reverse the array element.", extended="Example:\n > select _FUNC_(array) from src;")
public class UDFArrayReverse
extends GenericUDF {
    private static final int ARG_COUNT = 1;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient ArrayList<Object> result = new ArrayList();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function array_reverse(array) takes exactly 1 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_reverse, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.arrayElementOI)) {
            throw new UDFArgumentException("The function array_reverse does not support comparison for \"" + this.arrayElementOI.getTypeName() + "\" types");
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.arrayElementOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.arrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null || arrayLength <= 0) {
            return null;
        }
        if (arrayLength == 1) {
            return array;
        }
        this.result.clear();
        for (int i = arrayLength - 1; i >= 0; --i) {
            Object arrayElement = this.arrayOI.getListElement(array, i);
            this.result.add(arrayElement);
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 1);
        return "array_reverse(" + strings[0] + ")";
    }
}

