/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_shuffle", value="_FUNC_(array<E>) - Generates a random permutation of the given array.", extended="Example:\n > select _FUNC_(array) from src;")
public class UDFArrayShuffle
extends GenericUDF {
    private static final int ARG_COUNT = 1;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient ArrayList<Object> result = new ArrayList();
    private static final int INITIAL_LENGTH = 128;
    private int[] positions = new int[128];

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function array_shuffle(array) takes exactly 1 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_shuffle, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.arrayElementOI)) {
            throw new UDFArgumentException("The function array_shuffle does not support comparison for \"" + this.arrayElementOI.getTypeName() + "\" types");
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.arrayElementOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.arrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int i;
        Object array = arguments[0].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null || arrayLength <= 0) {
            return null;
        }
        if (arrayLength == 1) {
            return array;
        }
        this.result.clear();
        if (this.positions.length < arrayLength) {
            this.positions = new int[arrayLength];
        }
        for (i = 0; i < arrayLength; ++i) {
            this.positions[i] = i;
        }
        for (i = arrayLength - 1; i > 0; --i) {
            Random random = new Random();
            int index = random.nextInt(i + 1);
            int swap = this.positions[i];
            this.positions[i] = this.positions[index];
            this.positions[index] = swap;
        }
        for (i = 0; i < arrayLength; ++i) {
            Object arrayElement = this.arrayOI.getListElement(array, this.positions[i]);
            this.result.add(arrayElement);
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 1);
        return "array_shuffle(" + strings[0] + ")";
    }
}

