/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="array_slice", value="_FUNC_(array<E>, start, length) - subsets array starting from index start (or starting from the end if start is negative) with a length of length.", extended="Example:\n > select _FUNC_(array, start, length) from src;")
public class UDFArraySlice
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int START_IDX = 1;
    private static final int LENGTH_IDX = 2;
    private static final int ARG_COUNT = 3;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ArrayList<Object> result = new ArrayList();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 3) {
            throw new UDFArgumentLengthException("The function array_slice(array, start, length) takes exactly 3 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_slice, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        WritableIntObjectInspector expectOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        for (int i = 1; i < 3; ++i) {
            if (ObjectInspectorUtils.compareTypes((ObjectInspector)expectOI, (ObjectInspector)arguments[i])) continue;
            throw new UDFArgumentTypeException(i, "\"" + expectOI.getTypeName() + "\" expected at function array_slice, but \"" + arguments[i].getTypeName() + "\" is found");
        }
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.arrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        IntWritable start = (IntWritable)arguments[1].get();
        IntWritable length = (IntWritable)arguments[2].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (start == null || length == null || length.get() < 0) {
            return null;
        }
        if (arrayLength <= 0) {
            return array;
        }
        this.result.clear();
        if (start.get() < 0) {
            int idx = arrayLength + start.get();
            if (idx < 0) {
                idx = 0;
            }
            int i = idx;
            for (int j = 1; j <= length.get() && i < arrayLength; ++i, ++j) {
                this.result.add(this.arrayOI.getListElement(array, i));
            }
            return this.result;
        }
        for (int i = start.get(); i <= length.get() && i < arrayLength; ++i) {
            this.result.add(this.arrayOI.getListElement(array, i));
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 3);
        return "array_slice(" + strings[0] + ", " + strings[1] + "," + strings[2] + ")";
    }
}

