/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import com.github.aaronshan.functions.fastuitl.ints.IntArrays;
import com.github.aaronshan.functions.utils.ArrayUtils;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_sort", value="_FUNC_(array) - sorts and returns the array. The elements of array must be orderable.", extended="Example:\n > select _FUNC_(array) from src;")
public class UDFArraySort
extends GenericUDF {
    private static final int INITIAL_SIZE = 128;
    private static final int ARG_COUNT = 1;
    private int[] positions = new int[128];
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient ArrayList<Object> result = new ArrayList();

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The function array_sort(array) takes exactly 1 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_sort, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.arrayElementOI)) {
            throw new UDFArgumentException("The function array_sort does not support comparison for \"" + this.arrayElementOI.getTypeName() + "\" types");
        }
        this.converter = ObjectInspectorConverters.getConverter((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.arrayElementOI);
        return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.arrayElementOI);
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int i;
        Object array = arguments[0].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null || arrayLength <= 0) {
            return null;
        }
        if (arrayLength == 1) {
            return array;
        }
        if (this.positions.length < arrayLength) {
            this.positions = new int[arrayLength];
        }
        for (i = 0; i < arrayLength; ++i) {
            this.positions[i] = i;
        }
        IntArrays.quickSort(this.positions, 0, arrayLength, ArrayUtils.IntArrayCompare(array, this.arrayOI));
        this.result.clear();
        for (i = 0; i < arrayLength; ++i) {
            Object arrayElement = this.arrayOI.getListElement(array, this.positions[i]);
            this.result.add(arrayElement);
        }
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 1);
        return "array_sort(" + strings[0] + ")";
    }
}

