/*
 * Decompiled with CFR 0.152.
 */
package com.github.aaronshan.functions.array;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="array_value_count", value="_FUNC_(array<E>, E) - count array's element number that element value equals given value.", extended="Example:\n > select _FUNC_(array, value) from src;")
public class UDFArrayValueCount
extends GenericUDF {
    private static final int ARRAY_IDX = 0;
    private static final int VALUE_IDX = 1;
    private static final int ARG_COUNT = 2;
    private transient ObjectInspector valueOI;
    private transient ListObjectInspector arrayOI;
    private transient ObjectInspector arrayElementOI;
    private LongWritable result;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function array_value_count(array, value) takes exactly 2 arguments.");
        }
        if (!arguments[0].getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            throw new UDFArgumentTypeException(0, "\"array\" expected at function array_value_count, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        this.arrayOI = (ListObjectInspector)arguments[0];
        this.arrayElementOI = this.arrayOI.getListElementObjectInspector();
        this.valueOI = arguments[1];
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayElementOI, (ObjectInspector)this.valueOI)) {
            throw new UDFArgumentTypeException(1, "\"" + this.arrayElementOI.getTypeName() + "\" expected at function array_value_count, but \"" + this.valueOI.getTypeName() + "\" is found");
        }
        if (!ObjectInspectorUtils.compareSupported((ObjectInspector)this.valueOI)) {
            throw new UDFArgumentException("The function array_value_count does not support comparison for \"" + this.valueOI.getTypeName() + "\" types");
        }
        this.result = new LongWritable(0L);
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.result.set(0L);
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (array == null || arrayLength <= 0) {
            return this.result;
        }
        long count = 0L;
        for (int i = 0; i < arrayLength; ++i) {
            Object listElement = this.arrayOI.getListElement(array, i);
            if (ObjectInspectorUtils.compare((Object)value, (ObjectInspector)this.valueOI, (Object)listElement, (ObjectInspector)this.arrayElementOI) != 0) continue;
            ++count;
        }
        this.result.set(count);
        return this.result;
    }

    public String getDisplayString(String[] strings) {
        assert (strings.length == 2);
        return "array_value_count(" + strings[0] + ", " + strings[1] + ")";
    }
}

